package com.beiming.odr.user.api.dto;

import com.beiming.odr.user.api.util.JwtUtil;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * Package: com.beiming.odr.user.domain
 *
 * @Description： TODO
 * Author: daiql
 * Date: Created in 2023/2/17 17:07
 * Version: 0.0.1
 */
@Data
public class UserStationRelationDTO implements Serializable {
  private Integer orgId;
  private String orgtype;
  private String orgname;
  private String address;
  private String lonlat;
  private String contact;
  private String introduce;
  private String city;
  private String img;
  private String orgTypeCode;
  List<ImageArrDTO> imageArr;

  public String getImg() {
    if (StringUtils.isEmpty(img)) {
      return img;
    } else {
      String file = com.beiming.framework.util.StringUtils.substringAfterLast(img, "/");
      String sign = JwtUtil.jwtAes(file);
      return img + "?fileSec=" + sign;
    }
  }
}
