package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.odr.user.api.common.constants.UserConst;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Data;

/**
 * 普通用户注册
 */
@Data
public class CommonUserRegisterReqDTO implements Serializable {

  /**
   * 手机号
   */
  @NotBlank(message = "手机号码不能为空")
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "手机号码格式不对")
  private String mobilePhone;

  /**
   * 密码
   */
  private String password;

  private String idCard;

  private String name;

  private String registerOrigin;

  /**
   * 是否实名
   */
  private Boolean isRealName = false;

  /**
   * 是否完成人脸识别
   */
  private Boolean isFacialVerify = false;
}
