package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.constants.ValidateMessage;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 身份认证
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RealNameAuthenticationReqDTO implements Serializable {

  /**
   * 姓名
   */

  @NotBlank(message = "姓名不能为空")
  private String userName;
  /**
   * 身份证
   */
  @Pattern(regexp = UserConst.REGEX_ID_CARD, message = ValidateMessage.ID_CARD_NOT_INCORRECT)
  private String idCard;


}
