package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.odr.user.api.common.enums.MediationTypeEnum;
import java.io.Serializable;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Data;

@Data
public class RecommendOrganizationReqDTO implements Serializable {

  /**
   * 调解类型代码
   */
  @NotNull(message = "调解类型代码不能为空")
  private MediationTypeEnum mediateCode;

  /**
   * 纠纷类型代码
   */
  private String disputeTypeCode;

  /**
   * 纠纷发生地代码
   */
  @NotEmpty(message = "纠纷发生地代码不能为空")
  private String disputeAreaCode;

  /**
   * 纠纷发生地地址等级
   */
  @NotNull(message = "纠纷发生地地址等级不能为空")
  private Integer disputeAreaLevel;

  private Integer filterFlag;
}
