package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.framework.page.PageQuery;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

@Data
public class ServicePersonListReqDTO extends PageQuery implements Serializable {

  /**
   * appName
   */
  private String appName;
  /**
   * 人员名称
   */
  private String userName;

  /**
   * 机构id
   */
  private Long orgId;

  /**
   * 擅长领域
   */
  private String ability;

  /**
   * 调解方式
   */
  private String mediateCode;

  /**
   * 人员类型（调解员、咨询师、法官）
   */
  private String roleType;

  /**
   * 角色名称：金牌调解员、公证调解员等，在roleType下面
   */
  private String roleCode;

  /**
   * 区域代码
   */
  private String areaCode;

  /**
   * 服务区域代码前两位（匹配省）
   */
  private String serviceAreaCodeTwo;

  /**
   * 服务区域代码前四位（匹配市）
   */
  private String serviceAreaCodeFour;

  /**
   * 服务区域代码前六位（匹配区）
   */
  private String serviceAreaCodeSix;

  /**
   * 服务区域代码前九位（匹配街道）
   */
  private String serviceAreaCodeNine;
  /**
   * 服务区域代码十二位（匹配社区）
   */
  private String serviceAreaCodeTwelve;

  /**
   * 当前登录用户id
   */
  private String currentUserId;

  /**
   * 备注
   */
  private String remark;

  /**
   * 关键字（用户名称或擅长领域）
   */
  private String keywords;

  /**
   * 需排除的调解员id
   */
  private List<Long> excludeUserIds;

  /**
   * 列表类型 协助调解员列表 服务资源列表
   */
  private String listType;

  /**
   * 总对总调解机构下级分类
   */
  private String inviteOrg;

  private String typeCode;

  private List<String> roleCodes;
  /***
   * 多选擅长领域
   */
  private List<String> abilityList;

}
