
package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Data;

/**
 * 特邀调解机构请求参数
 */
@Data
public class TeyaoMediateOrganizationUpdateReqDTO implements Serializable {

  /**
   * 主键
   */
  private Long id;

  /**
   * 机构代码
   */
  private String code;

  /**
   * 机构名称
   */
  @NotBlank(message = "机构名称不能为空")
  private String name;

  /**
   * 机构类型代码
   */
  @NotBlank(message = "机构类型代码不能为空")
  private String typeCode;

  /**
   * 机构类型名称
   */
  @NotBlank(message = "机构类型名称不能为空")
  private String typeName;

  /**
   * 调解类型代码
   */
  @NotBlank(message = "调解类型代码不能为空")
  private String mediateCode;

  /**
   * 调解类型名称
   */
  @NotBlank(message = "调解类型名称不能为空")
  private String mediateName;

  /**
   * 省
   */
  private String provinceCode;

  /**
   * 省名称
   */
  private String provinceName;

  /**
   * 市代码
   */
  private String cityCode;

  /**
   * 市名称
   */
  private String cityName;

  /**
   * 区代码
   */
  private String areaCode;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道代码
   */
  private String streetCode;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 社区代码
   */
  private String communityCode;

  /**
   * 社区名称
   */
  private String communityName;

  /**
   * 机构详细地址
   */
  private String detailedAddress;

  /**
   * 负责人
   */
  @NotBlank(message = "机构负责人不能为空")
  private String headName;

  /**
   * 负责人联系电话
   */
  @NotBlank(message = "负责人联系方式不能为空")
  private String headContactPhone;

  /**
   * 联系人
   */
  private String contactName;

  /**
   * 联系人电话
   */
  private String contactPhone;

  /**
   * 纠纷类型代码
   */
  @NotBlank(message = "纠纷类型代码不能为空")
  private String disputeTypeCode;

  /**
   * 纠纷类型名称
   */
//  @NotBlank(message = "纠纷类型名称不能为空")
  private String disputeTypeName;

  /**
   * 文件列表
   */
  private List<TeyaoMediateUserFileReqDTO> fileList;


}