package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 特邀出库修改请求参数
 */
@Data
public class TeyaoMediateOutStoreUpdateReqDTO implements Serializable {

  /**
   * 主键
   */
  private Long id;

  /**
   * 用户编号
   */
  @NotNull(message = "业务编号不能为空")
  private Long businessId;

  /**
   * 出库类型(USER-用户 ORG-机构)
   */
  @NotNull(message = "出库类型不能为空")
  private String outType;

  /**
   * 出库原因
   */
  private String outDesc;

  /**
   * 出库时间
   */
  private Date outTime;

}