package com.beiming.odr.user.api.dto.requestdto;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 特邀用户入库请求参数
 */
@Data
public class TeyaoMediateStoreReqDTO implements Serializable {

  /**
   * 机构编号（特邀调解机构新增调解员时传入）
   */
  private Long orgId;

  private String orgName;

  /**
   * 用户姓名
   */
  @NotBlank(message = "姓名不能为空")
  private String userName;

  /**
   * 性别
   */
  @NotBlank(message = "性别不能为空")
  private String sex;

  /**
   * 身份证
   */
  private String idCard;

  /**
   * 手机号
   */
  @NotBlank(message = "手机号码不能为空")
  private String mobilePhone;

  /**
   * 微信号
   */
  private String wechatNo;

  /**
   * 头像
   */
  private String headPortraitUrl;

  /**
   * 政治面貌
   */
  private String politicalOutlook;

  /**
   * 学历
   */
  private String education;

  /**
   * 单位
   */
  @NotBlank(message = "单位不能为空")
  private String workOrganization;

  /**
   * 擅长领域
   */
  @NotBlank(message = "擅长领域不能为空")
  private String ability;

  /**
   * 服务职能
   */
  private String job;

  /*
   * [{provinceCode：, provinceName：, cityCode：, cityName：, areaCode：, areaName：, streetCode：,
   * streetName：, communitCode：, communityName：, detailedAddress：},{....}]
   */
  /**
   * 通讯地址
   */
//  @NotNull(message = "通讯地址不能为空")
  private JSONObject address;

  private List<TeyaoMediateUserFileReqDTO> fileList;

}