package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;
import lombok.Data;

/**
 * 特邀调解员审核请求参数
 */
@Data
public class TeyaoMediateUserAuthReqDTO implements Serializable {

  /**
   * 审核记录编号
   */
  @NotNull(message = "审核记录编号不能为空")
  private List<Long> ids;

  /**
   * 审核结果
   */
  @NotBlank(message = "审核结果不能为空")
  private String mediateAuthStatus;

  /**
   * 审核意见
   */
  private String authDesc;

}