package com.beiming.odr.user.api.dto.requestdto;

import com.alibaba.fastjson.JSONArray;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 更新用户详细信息
 */
@Data
public class UserUpdateReqDTO implements Serializable {

  public UserUpdateReqDTO() {

  }

  public UserUpdateReqDTO(AddServicePersonReqDTO req) {
    this.userId = req.getUserId();
    this.nation = req.getNation();
    this.sex = req.getSex();
    this.mechanismType = req.getMechanismType();
    this.ability = req.getAbility();
    this.serviceAreaCode = req.getServiceAreaCode();
    this.serviceAreaName = req.getServiceAreaName();
    this.birthday = req.getBirthday();
    this.district = req.getDistrict();
    this.education = req.getEducation();
    this.experience = req.getExperience();
    this.job = req.getJob();
    this.employmentTime = req.getEmploymentTime();
    this.workOrganization = req.getWorkOrganization();
    this.politicalOutlook = req.getPoliticalOutlook();
    this.occupation = req.getOccupation();
    this.graduateSchool = req.getGraduateSchool();
    this.email = req.getEmail();
  }

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 民族
   */
  private String nation;

  /**
   * 性别
   */
  private String sex;

  /**
   * 机构类型
   */
  private String mechanismType;

  /**
   * 擅长领域
   */
  private String ability;

  /**
   * 服务区代码
   */
  private String serviceAreaCode;

  /**
   * 服务区名称
   */
  private String serviceAreaName;

  /**
   * 生日
   */
  private String birthday;

  /**
   * 行政区
   */
  private String district;

  /**
   * 文化程度
   */
  private String education;

  /**
   * 从业经历
   */
  private String experience;

  /**
   * 服务职能
   */
  private String job;

  /**
   * 从业时间
   */
  private Date employmentTime;

  /**
   * 工作机构
   */
  private String workOrganization;

  /**
   * 政治面貌
   */
  private String politicalOutlook;

  /**
   * 职业
   */
  private String occupation;

  /**
   * 毕业学习
   */
  private String graduateSchool;

  /**
   * 邮箱
   */
  private String email;


  /*
   * [{provinceCode：, provinceName：, cityCode：, cityName：, areaCode：, areaName：, streetCode：,
   * streetName：, communitCode：, communityName：, detailedAddress：},{....}]
   */
  /** 用户证件集合 */
  private JSONArray userCertificates;
  /** 用户角色关系集合 */
  private JSONArray userRoleRelation;

}
