package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author sunjie
 * @description:
 * @date 2023/2/14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WorkRegisterDTO implements Serializable {

  /**
   * id
   */
  private Integer id;

  /**
   * 工作名称
   */
  private String name;

  /**
   * 工作类型
   */
  @NotNull(message = "工作类型不能为空")
  private String type;

  /**
   * 登记时间
   */
  private String registerTime;

  /**
   * 承办部门
   */
  private String undertakeDepartment;

  /**
   * 站点
   */
  private String site;

  /**
   * 站点代码
   */
  private List<String> siteCodes;

  /**
   * siteCodes转JSONString
   */
  private String scString;

  /**
   * 案号
   */
  private String caseNo;

  /**
   * 当事人人数
   */
  private Integer partyNum;

  /**
   * 旁听人数
   */
  private Integer audienceNum;

  /**
   * 参与人数
   */
  private Integer participationNum;

  /**
   * 备注
   */
  private String remarks;

  /**
   * 活动内容
   */
  private String content;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private String createTime;

  /**
   * 更新人
   */
  private String updateUser;

  /**
   * 更新时间
   */
  private String updateTime;

  /**
   * 状态 0 正常 1 删除
   */
  private Integer status;


  private Integer siteId;

  private boolean updateRole;
  /**
   * 案件来源类型
   */
  private String caseOrigin;

  /**
   * 案件来源类型 名称
   */
  private String caseOriginName;
  /**
   * 微解纷案号
   */
  private String wjfCaseNo;
  /**
   * 法院委派案号
   */
  private String courtAssignedCaseNo;
  /**
   * 调解组织
   */
  private Long orgId;
  /**
   * 调解组织名称
   */
  private String orgName;
  /**
   * 调解员名称
   */
  private String mediatorName;
  /**
   * 调解员id
   */
  private String mediatorId;
  /***
   * 优化案件的申请人
   */
  private List<WorkRegisterPersonnelDTO> applicantPersonnelList;
  /***
   * 优化案件的申请人，被申请人信息
   */
  private List<WorkRegisterPersonnelDTO> respondentPersonnelList;
  /**
   * 案件类型字典表code
   */
  private String disputeTypeCode;
  /**
   * 案件类型-纠纷类型
   */
  private String disputeType;
  /**
   * 调解开始时间
   */
  private String startTime;
  /**
   * 调解结束时间
   */
  private String endTime;

  /**
   * 调解开始时间
   */
  private String startTimeStr;
  /**
   * 调解结束时间
   */
  private String endTimeStr;
  /**
   * 调解结果
   */
  private String mediationResult;
  /**
   * 调解结果编码
   */
  private String mediationResultCode;
  /**
   * 调解成功金额
   */
  private String mediationSuccessAmont;

  /**
   * 佐证材料ID
   */
  private List<WorkRegisterEvidentialMaterialsDTO> fileList;
}
