package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author sunjie
 * @description:
 * @date 2023/2/14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WorkRegisterParamDTO implements Serializable {

  /**
   * id
   */
  private Integer id;

  /**
   * 工作名称
   */
  private String name;

  /**
   * 工作类型
   */
  @NotNull(message = "工作类型不能为空")
  private String type;


  private String timeInterval;
  private String startTime;
  private String endTime;

  /**
   * 承办部门
   */
  private String undertakeDepartment;

  /**
   * 站点
   */
  private String site;

  /**
   * 案号
   */
  private String caseNo;

  /**
   * 当事人人数
   */
  private Integer partyNum;

  /**
   * 旁听人数
   */
  private Integer audienceNum;

  /**
   * 参与人数
   */
  private Integer participationNum;

  /**
   * 备注
   */
  private String remarks;

  /**
   * 活动内容
   */
  private String content;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private String createTime;

  /**
   * 更新人
   */
  private String updateUser;

  /**
   * 更新时间
   */
  private String updateTime;

  /**
   * 状态 0 正常 1 删除
   */
  private Integer status;

  /**
   * 页码
   */
  private Integer pageIndex;

  /**
   * 每页记录数
   */
  private Integer pageSize;

  /**
   * 站点id
   */
  private Integer siteId;
  /***
   * 站点类型编码组
   */
  private String siteCodes;
}
