package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.odr.user.api.common.enums.CertificatesTypeEnum;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 工作登记案件人员表
 *
 * @TableName work_register_personnel
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WorkRegisterPersonnelDTO implements Serializable {

    /**
     *
     */
    private Long id;
    /**
     * 工作登记ID
     */

    private Integer workRegisterId;
    /**
     * 用户id
     */

    private Long userId;
    /**
     * 案件用户类型（申请人 ,被申请人, 调解员）
     */
    private String caseUserType;
    /**
     * 用户类型（自然人,法人,非法人组织）
     */
    private String userType;
    /**
     * 名称(类别为法人/非法人组织时, 填单位名称)
     */
    private String userName;
    /**
     * 性别
     */
    private String sex;
    /**
     *
     */
    private String phone;
    /**
     * 证件类型
     */
    private CertificatesTypeEnum certificateType = CertificatesTypeEnum.ID_CARD;
    /**
     *
     */
    private String idCard;
    /**
     * 省code
     */
    private String provCode;
    /**
     * 市code
     */
    private String cityCode;
    /**
     * 区code
     */
    private String areaCode;
    /**
     * 街道code
     */
    private String streetCode;
    /**
     * 省名称
     */
    private String provName;
    /**
     * 市名称
     */
    private String cityName;
    /**
     * 区名称
     */
    private String areaName;
    /**
     * 街道名称
     */
    private String streetName;
    /**
     * 详细地址
     */
    private String address;
    /**
     * 创建人名字
     */
    private String createUser;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新人名字
     */

    private String updateUser;
    /**
     * 更新时间
     */

    private Date updateTime;
    /**
     * 固定电话
     */
    private String telephone;

}
