package com.beiming.odr.user.api.dto.responsedto;

import com.beiming.odr.user.api.common.enums.PublishStatusEnums;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;


/**
 * 新闻实体类
 */
@Data
public class NewsInformationResDTO implements Serializable {

  /**
   * 自增
   */
  private Long id;

  /**
   * 标题
   */
  private String title;

  /**
   * 缩略图
   */

  private String imgUrl;

  /**
   * 作者
   */
  private String author;

  /**
   * 来源渠道
   */
  private String sourceChannel;

  /**
   * 新闻类型代码
   */
  private String newsTypeCode;

  /**
   * 新闻类型名称
   */
  private String newsTypeName;

  /**
   * 内容简介
   */
  private String shortContent;
  /**
   * 内容
   */
  private String content;

  /**
   * 发布时间
   */
  private String publishDate;

  /**
   * 发布状态(Unpublished 未发布，published 发布，Revoke 撤销)
   */
  private PublishStatusEnums publishStatus;

  /**
   * 浏览数量
   */
  private Integer browseNumber;

  /**
   * 上一页
   * */
  private NewsInformationResDTO frontPage;

  /**
   * 下一页
   * */
  private NewsInformationResDTO nextPage;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 版本号
   */
  private Integer version;

  /**
   * 状态 0 正常 1 删除
   */
  private String status;

  /**
   * 备注
   */
  private String remark;

}
