package com.beiming.odr.user.api.dto.responsedto;

import com.beiming.odr.user.api.util.JwtUtil;
import java.io.Serializable;
import java.util.List;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 */
@Data
public class RoleUserInfoListResDTO implements Serializable {

  /**
   * 用户编号
   */
  private String id;

  /**
   * 用户名称
    */
  private String name;

  /**
   * 手机号
   */
  private String mobilePhone;

  /**
   * 头像
   */
  private String headPortraitUrl;

  /**
   * 人员类型
   */
  private String personType;

  /**
   * 微信openId
   */
  private String openId;

  public String getHeadPortraitUrl() {
    if (StringUtils.isEmpty(headPortraitUrl)) {
      return headPortraitUrl;
    } else {
      String file = com.beiming.framework.util.StringUtils.substringAfterLast(headPortraitUrl, "/");
      String sign = JwtUtil.jwtAes(file);
      return headPortraitUrl + "?fileSec=" + sign;
    }
  }

}