package com.beiming.odr.user.api.dto.responsedto;

import com.beiming.framework.util.StringUtils;
import java.io.Serializable;
import lombok.Data;

@Data
public class ServicePersonListResponseDTO implements Serializable {
  /**
   * 用户id
   */
  private Long userId;
  /**
   * 头像
   */
  private String headPortraitUrl;
  
  /**
   * 用户名称
   */
  private String userName;
  
  /**
   * 地区
   */
  private String serviceArea;
  
  /**
   * 工作经验
   */
  private String workExperience;
  
  /**
   * 擅长领域
   */
  private String ability;
  
  /**
   * 擅长领域数组
   */
  private String[] abilitys;
  
  /**
   * 角色名称
   */
  private String roleName;
  
  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 星级
   */
  private Integer starLevel;
  
  /**
   * 评价数
   */
  private Integer evaluateNumber;
  
  /**
   * 纠纷数量
   */
  private Integer disputeNumber;
  
  /**
   * 正在调解的纠纷数量
   */
  private Integer notEndDisputeNumber;
  
  /**
   * 已调解的纠纷数量
   */
  private Integer endDisputeNumber;
  
  /**
   * 性别
   */
  private String sex;
  
  /**
   * 在线繁忙状态
   */
  private String servicePersonStatus;
  
  /**
   * 机构管理员角色名称
   */
  private String orgManagerRoleName;
  
  /**
   * 机构管理员名称
   */
  private String orgManagerName;
  
  /**
   * 机构所在区域地址
   */
  private String orgAreaAddress;
  

  public ServicePersonListResponseDTO() {
    super();
  }

  public ServicePersonListResponseDTO(ServicePersonListResDTO servicePersonListResDTO) {
    super();
    this.userId = servicePersonListResDTO.getUserId();
    this.headPortraitUrl = servicePersonListResDTO.getHeadPortraitUrl();
    this.userName = servicePersonListResDTO.getUserName();
    this.serviceArea = servicePersonListResDTO.getServiceAreaName();
    this.ability = servicePersonListResDTO.getAbility();
    this.roleName = servicePersonListResDTO.getRoleName();
    this.orgName = servicePersonListResDTO.getOrgName();
    this.sex = servicePersonListResDTO.getSex();
    
    if (servicePersonListResDTO.getEmploymentTime() != null ) {
      int day = (int) ((System.currentTimeMillis() - servicePersonListResDTO.getEmploymentTime().getTime()) / (24 * 60 * 60 * 1000));
      int year = day / 365;
      this.workExperience = String.valueOf(year);
    }
    if (StringUtils.isNotBlank(this.ability)) {
      String abilityTemp = this.ability.replace("，", ",");
      abilityTemp = abilityTemp.replace("、", ",");
      this.abilitys = abilityTemp.split(",");
    }
    this.orgManagerRoleName = servicePersonListResDTO.getOrgManagerRoleName();
    this.orgManagerName = servicePersonListResDTO.getOrgManagerName();
    if (StringUtils.isNotBlank(servicePersonListResDTO.getOrgCommunityName())) {
      this.orgAreaAddress = servicePersonListResDTO.getOrgCommunityName();
    } else if (StringUtils.isNotBlank(servicePersonListResDTO.getOrgStreetName())) {
      this.orgAreaAddress = servicePersonListResDTO.getOrgStreetName();
    } else if (StringUtils.isNotBlank(servicePersonListResDTO.getOrgAreaName())) {
      this.orgAreaAddress = servicePersonListResDTO.getOrgAreaName();
    } else if (StringUtils.isNotBlank(servicePersonListResDTO.getOrgCityName())) {
      this.orgAreaAddress = servicePersonListResDTO.getOrgCityName();
    }
  }
  
}
