
package com.beiming.odr.user.api.dto.responsedto;


import com.alibaba.fastjson.JSONObject;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateUserFileReqDTO;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Data;

@Data
public class TeyaoMediateUserDetailResDTO implements Serializable {

  /**
   * 主键
   */
  private Long id;

  /**
   * 用户姓名
   */
  @NotBlank(message = "姓名不能为空")
  private String userName;

  /**
   * 性别
   */
  @NotBlank(message = "性别不能为空")
  private String sex;

  /**
   * 身份证
   */
  @NotBlank(message = "身份证号不能为空")
  private String idCard;

  /**
   * 手机号
   */
  @NotBlank(message = "手机号码不能为空")
  private String mobilePhone;

  /**
   * 微信号
   */
  private String wechatNo;

  /**
   * 头像
   */
  private String headPortraitUrl;


  /**
   * 政治面貌
   */
  private String politicalOutlook;

  /**
   * 学历
   */
  private String education;

  /**
   * 单位
   */
  @NotBlank(message = "单位不能为空")
  private String workOrganization;

  /**
   * 擅长领域
   */
  @NotBlank(message = "擅长领域不能为空")
  private String ability;

  /**
   * 服务职能
   */
  private String job;

  private Long orgId;

  private String orgName;

  /**
   * 通讯地址
   */
  @NotNull(message = "通讯地址不能为空")
  private JSONObject address;

  /**
   * 文件列表
   */
  private List<TeyaoMediateUserFileReqDTO> fileList;

  /**
   * 状态
   */
  private String mediateAuthStatus;

  /**
   * 出库信息
   */
  private TeyaoMediateOutStoreResDTO outStoreResDTO;

  /**
   * 培训信息
   */
  private TeyaoMediateStudyResDTO studyResDTO;

  /**
   * 表彰信息
   */
  private TeyaoMediateCommendResDTO commendResDTO;

}