package com.beiming.odr.user.api.dto.responsedto;

import java.io.Serializable;
import java.util.Date;

import com.beiming.odr.user.api.util.JwtUtil;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

@Data
public class UserOrgPersonResDTO  implements Serializable {
  /**
   * 用户ID
   */
  private Long id;

  /**
   * 用户登录名
   */
  private String loginName;

  /**
   * 手机号
   */
  private String mobilePhone;

  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 头像
   */
  private String headPortraitUrl;

  /**
   * 最后登录时间
   */
  private Date lastLoginTime;

  /**
   * 人员类型
   */
  private String personType;

  /**
   * 业务人员类型
   * */
  private String businessPeopleType;

  /**
   * 微信openId
   */
  private String openId;


  private String roleCode;

  private String areaCode;

  public String getHeadPortraitUrl() {
    if (StringUtils.isEmpty(headPortraitUrl)) {
      return headPortraitUrl;
    } else {
      String file = com.beiming.framework.util.StringUtils.substringAfterLast(headPortraitUrl, "/");
      String sign = JwtUtil.jwtAes(file);
      return headPortraitUrl + "?fileSec=" + sign;
    }
  }


}
