package com.beiming.odr.user.api.dto.responsedto;

import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;


/**
 * Alor 2024/12/11
 **/
@Data
public class WeAnalysisAppidDailyVisitTrendDTO implements Serializable {

  /***
   * 日期，格式为 yyyymmdd
   */
  @JSONField(name="ref_date")
  private String refDate;
  /***
   * 打开次数
   */
  @JSONField(name="session_cnt")
  private Integer sessionCnt;
  /***
   * 访问次数
   */
  @JSONField(name="visit_pv")
  private Integer visitPv;
  /***
   * 访问人数
   */
  @JSONField(name="visit_uv")
  private Integer visitUv;
  /***
   * 新用户数
   */
  @JSONField(name="visit_uv_new")
  private Integer visitUvNew;
  /***
   *人均停留时长 (浮点型，单位：秒)
   */
  @JSONField(name="stay_time_uv")
  private BigDecimal stayTimeUv;
  /***
   *次均停留时长 (浮点型，单位：秒)
   */
  @JSONField(name="stay_time_session")
  private BigDecimal stayTimeSession;

  public String getRefDate() {
    return refDate;
  }

  public void setRefDate(String refDate) {
    this.refDate = refDate;
  }

  public Integer getSessionCnt() {
    return sessionCnt;
  }

  public void setSessionCnt(Integer sessionCnt) {
    this.sessionCnt = sessionCnt;
  }

  public Integer getVisitPv() {
    return visitPv;
  }

  public void setVisitPv(Integer visitPv) {
    this.visitPv = visitPv;
  }

  public Integer getVisitUv() {
    return visitUv;
  }

  public void setVisitUv(Integer visitUv) {
    this.visitUv = visitUv;
  }

  public Integer getVisitUvNew() {
    return visitUvNew;
  }

  public void setVisitUvNew(Integer visitUvNew) {
    this.visitUvNew = visitUvNew;
  }

  public BigDecimal getStayTimeUv() {
    return stayTimeUv;
  }

  public void setStayTimeUv(BigDecimal stayTimeUv) {
    this.stayTimeUv = stayTimeUv;
  }

  public BigDecimal getStayTimeSession() {
    return stayTimeSession;
  }

  public void setStayTimeSession(BigDecimal stayTimeSession) {
    this.stayTimeSession = stayTimeSession;
  }

  public BigDecimal getVisitDepth() {
    return visitDepth;
  }

  public void setVisitDepth(BigDecimal visitDepth) {
    this.visitDepth = visitDepth;
  }

  /***
   *平均访问深度
   */
  @JSONField(name="visit_depth")
  private BigDecimal visitDepth;
}
