package com.beiming.odr.user.api.dto.responsedto.xinshiyun;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

@Data
public class SyzlOrganUserDTO implements Serializable {

  /**
   * 机构ID
   */
  private Long orgId;
  /**
   * 机构名称
   */
  private String orgName;
  /**
   * 上级机构ID
   */
  private Long parentId;
  /**
   * 上级机构名称
   */
  private String parentName;
  /**
   * 机构地址
   */
  private String address;
  /**
   * 机构类型：  InviteOrgEnum
   *   PEOPLE_COURT("人民法庭"),
   *   BASIC_GOVERN_UNIT("基层治理单位"),
   *   VILLAGE_MEDIATE_ORG("乡村调解机构"),
   *   COMMUNITY_MEDIATE_ORG("社区调解机构"),
   *   GRID_MEDIATE_ORG("网格调解机构"),
   */
  private String inviteOrg;
  /**
   * 机构联系人
   */
  private String contactName;
  /**
   * 机构联系人电话
   */
  private String contactPhone;

  /**
   * 用户ID
   */
  private Long userId;
  /**
   * 用户名称
   */
  private String userName;
  /**
   * 用户手机号码
   */
  private String mobilePhone;
  /**
   * 擅长领域
   */
  private String ability;
  /**
   * 性别
   */
  private String sex;

  /**
   * 创建时间
   */
  private Date createTime;
  /**
   * 修改时间
   */
  private Date updateTime;
  /**
   * 机构状态： 0 正常 1 删除
   */
  private String status;

  /**
   * 所属法院编号
   */
  private String fybh;
  /**
   * 法庭编号
   */
  private String ftbh;
  /**
   * 单位编号
   */
  private String dwbh;
  /**
   * 单位人员编号
   */
  private String dwrybh;
  /**
   * 上报类型：1法庭，2单位，3人员，4案件
   */
  private Integer reportType = 0;
  /**
   * 上报状态：1新增，2修改，3删除
   */
  private Integer reportStatus = 0;
  /**
   * 上报创建时间
   */
  private Date reportCreateTime;
  /**
   * 上报更新时间
   */
  private Date reportUpdateTime;

}
