package com.beiming.odr.user.api.enums;

import java.util.Arrays;
import java.util.Optional;
import lombok.Getter;

public enum DisputeTypeCaseTypeEnum {

  /**
   * 目前微解纷只有行政、民事类型，先取新视云的类型做映射区分 新视云接口案件类型 1.刑事 2.行政 3.民事 4.执行'
   */
  CRIMINAL("刑事", 1),
  ADMINISTRATIVE("行政", 2),
  CIVIL("民事", 3),
  EXECUTION("执行", 4),
  ;

  @Getter
  private String desc;

  @Getter
  private Integer xinShiYunCaseTypeCode;

  DisputeTypeCaseTypeEnum(String desc, Integer caseType) {
    this.desc = desc;
    this.xinShiYunCaseTypeCode = caseType;
  }


  public static DisputeTypeCaseTypeEnum getCaseType(Integer xinShiYunCaseTypeCode) {
    Optional<DisputeTypeCaseTypeEnum> first = Arrays.stream(DisputeTypeCaseTypeEnum.values())
        .filter(x -> x.getXinShiYunCaseTypeCode().equals(xinShiYunCaseTypeCode)).findFirst();
    return first.orElseGet(null);
  }
}
