package com.beiming.odr.user.api.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 纠纷类型自2023-01由 dispute_type维护 此处只用于特殊场景
 */
public enum DisputeTypeEnum {

  /**
   * 民事纠纷 code值 9000-9999
   */
  CIVIL_DISPUTE(9000L, "民事纠纷", null),

  /**
   * 其他民事纠纷：非内网标准，仅微解纷
   */
  CIVIL_OTHER_DISPUTE(9999L, "其他民事纠纷", "OTHER_DISPUTES"),

  /**
   * 行政纠纷：内网标准未启用(code值6000-6999)，实际维持原纠纷类型，code映射为7000-7999
   */
  ADMINISTRATIVE_DISPUTES(6000L, "行政纠纷", null),

  /**
   * 微解纷旧的案由，兼容阶段仅做筛选不做新增，此处用于判断
   */
  CIVIL_DISPUTE_OLD(8000L,"旧民事纠纷","DISPUTE_TYPE");

  @Getter
  private Long code;

  @Getter
  private String name;

  //旧案由，部分推送到其他平台需要用到
  @Getter
  private String oldCode;

  DisputeTypeEnum(Long code, String name, String oldCode) {
    this.code = code;
    this.name = name;
    this.oldCode = oldCode;
  }

  public static boolean isCivilDispute(Integer xinShiYunCaseType) {
    return DisputeTypeCaseTypeEnum.CIVIL.getXinShiYunCaseTypeCode().equals(xinShiYunCaseType);
  }

  public static boolean isAdministrativeDispute(Integer xinShiYunCaseType) {
    return DisputeTypeCaseTypeEnum.ADMINISTRATIVE.getXinShiYunCaseTypeCode()
        .equals(xinShiYunCaseType);
  }

  public static boolean isCivilDisputeOld(String disputeCode) {
    boolean numeric = StringUtils.isNumeric(disputeCode);
    if (numeric) {
      //8000-8999为disputeType表内的旧案由
      Long disputeNumCode = Long.valueOf(disputeCode);
      return disputeNumCode >= 8000 && disputeNumCode < 9000;
    }
    //字符串类型的是旧案由
    return true;
  }

}


