package com.beiming.odr.user.api.xinshiyun;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.xinshiyun.SyzlOrganUserReportDTO;
import com.beiming.odr.user.api.dto.responsedto.xinshiyun.SyzlOrganUserDTO;
import com.beiming.odr.user.api.dto.responsedto.xinshiyun.SyzlReportConfigDTO;
import com.beiming.odr.user.api.dto.responsedto.xinshiyun.XinshiyunMediatorRepDTO;
import com.beiming.odr.user.api.dto.responsedto.xinshiyun.XinshiyunOrganizationRepDTO;
import com.beiming.odr.user.api.dto.responsedto.xinshiyun.XinshiyunUserRepDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 机构相关接口
 *
 * @author fanheshui
 */
public interface XinshiyunUserPushServiceApi {

  public DubboResult<PageInfo<XinshiyunOrganizationRepDTO>> selectOrganizationToPushXinshiyun(List<String> orgList);

  public DubboResult<PageInfo<XinshiyunMediatorRepDTO>> selectPushXinshiyunMeiator(
      List<String> userIds, Date yesterday);

  public DubboResult<XinshiyunUserRepDTO> selectUser(Long userId);

  /**
   * 诉源治理，获取配置信息
   */
  DubboResult<ArrayList<SyzlReportConfigDTO>> querySyzlReportConfig(String fybh);
  /**
   * 诉源治理，保存生成的rsa密钥
   */
  DubboResult<Boolean> updateSyzlRsaKey(SyzlReportConfigDTO syzlReportConfigDTO);
  /**
   * 诉源治理，获取诉源治理全部机构信息
   */
  DubboResult<ArrayList<SyzlOrganUserDTO>> querySyzlOrganization(String orgIds);
  /**
   * 诉源治理，获取诉源治理全部人员信息
   */
  DubboResult<ArrayList<SyzlOrganUserDTO>> querySyzlUser(String orgIds);
  /**
   * 诉源治理，上报结果保存
   */
  DubboResult<Boolean> saveSyzlOrganUserReportResult(SyzlOrganUserReportDTO syzlOrganUserReportDTO);

  DubboResult<ArrayList<Long>> getTestUserIds();

}
