/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.user.api.common.utils;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.AppNameEnums;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.user.api.common.enums.PasswordFormatTypeEnum;
import com.beiming.odr.user.api.common.utils.Encrypt;
import com.beiming.odr.user.api.common.utils.PassWordUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CommonPasswordValidateUtil {
    public static Boolean checkPasswordFlag(String password, String encodePassWord) {
        if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            return Encrypt.matches(password, encodePassWord);
        }
        return PassWordUtil.matches(password, encodePassWord);
    }

    public static String encodePassWord(String passWord) {
        if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            return Encrypt.md5(passWord);
        }
        return PassWordUtil.encodePassWord(passWord);
    }

    public static void checkPasswordFormat(PasswordFormatTypeEnum format, String password, String errorMessage) {
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)password), (ResultCode)DubboResultCodeEnums.PARAM_ERROR, (String)errorMessage);
        if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            CommonPasswordValidateUtil.checkRegexFormat(password, errorMessage, "^.{6,}$");
        } else {
            String reg = "";
            reg = PasswordFormatTypeEnum.USER_LOGIN.equals((Object)format) ? "^(?![A-Za-z0-9]+$)(?![a-z0-9-_~!@#$%=^&*()+\\`.]+$)(?![A-Za-z-_~!@#$%=^&*()+\\`.]+$)(?![A-Z0-9-_~!@#$%=^&*()+\\`.]+$)[a-zA-Z0-9-_~!@#$%=^&*()+'\\`'.]{8,30}$" : "^(?![A-Za-z0-9]+$)(?![a-z0-9-_~!@#$%=^&*()+\\`.]+$)(?![A-Za-z-_~!@#$%=^&*()+\\`.]+$)(?![A-Z0-9-_~!@#$%=^&*()+\\`.]+$)[a-zA-Z0-9-_~!@#$%=^&*()+'\\`'.]{8,30}$";
            CommonPasswordValidateUtil.checkRegexFormat(password, errorMessage, reg);
        }
    }

    private static void checkRegexFormat(String password, String message, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(password);
        AssertUtils.assertTrue((boolean)matcher.matches(), (ResultCode)DubboResultCodeEnums.PARAM_ERROR, (String)message);
    }

    public static String setDefaultPassword() {
        if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            return "69a25121b0fc99b67ad2356ffeca4cbe";
        }
        return "69a25121b0fc99b67ad2356ffeca4cbe";
    }
}

