/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.user.api.enums;

import com.beiming.odr.user.api.enums.DisputeTypeCaseTypeEnum;
import org.apache.commons.lang3.StringUtils;

public enum DisputeTypeEnum {
    CIVIL_DISPUTE(9000L, "\u6c11\u4e8b\u7ea0\u7eb7", null),
    CIVIL_OTHER_DISPUTE(9999L, "\u5176\u4ed6\u6c11\u4e8b\u7ea0\u7eb7", "OTHER_DISPUTES"),
    ADMINISTRATIVE_DISPUTES(6000L, "\u884c\u653f\u7ea0\u7eb7", null),
    CIVIL_DISPUTE_OLD(8000L, "\u65e7\u6c11\u4e8b\u7ea0\u7eb7", "DISPUTE_TYPE");

    private Long code;
    private String name;
    private String oldCode;

    private DisputeTypeEnum(Long code, String name, String oldCode) {
        this.code = code;
        this.name = name;
        this.oldCode = oldCode;
    }

    public static boolean isCivilDispute(Integer xinShiYunCaseType) {
        return DisputeTypeCaseTypeEnum.CIVIL.getXinShiYunCaseTypeCode().equals(xinShiYunCaseType);
    }

    public static boolean isAdministrativeDispute(Integer xinShiYunCaseType) {
        return DisputeTypeCaseTypeEnum.ADMINISTRATIVE.getXinShiYunCaseTypeCode().equals(xinShiYunCaseType);
    }

    public static boolean isCivilDisputeOld(String disputeCode) {
        boolean numeric = StringUtils.isNumeric((CharSequence)disputeCode);
        if (numeric) {
            Long disputeNumCode = Long.valueOf(disputeCode);
            return disputeNumCode >= 8000L && disputeNumCode < 9000L;
        }
        return true;
    }

    public Long getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getOldCode() {
        return this.oldCode;
    }
}

