/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.admin.schedule.user;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.admin.schedule.handler.CapacityAssessmentJobHandler;
import com.beiming.odr.referee.api.StatementStatisticsApi;
import com.beiming.odr.referee.dto.requestdto.MediateStatisticsReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationAssistStatisticsResDTO;
import com.beiming.odr.user.api.CapacityAssessmentTaskApi;
import com.beiming.odr.user.api.common.enums.ApplicableObjectEnums;
import com.beiming.odr.user.api.dto.requestdto.CapacityAssessmentTaskListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RefereeMediateStatiscsResDTO;
import com.beiming.odr.user.api.dto.responsedto.ExecutionCapacityAssessmentInitResDTO;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CapacityAssessmentOrgManageJob
implements SimpleJob {
    private static final Logger log = LoggerFactory.getLogger(CapacityAssessmentOrgManageJob.class);
    @Resource
    CapacityAssessmentTaskApi capacityAssessmentTaskApi;
    @Resource
    StatementStatisticsApi statementStatisticsApi;

    public void execute(ShardingContext arg0) {
        String jobParameter = arg0.getJobParameter();
        log.info("jobParameter is : {}", (Object)jobParameter);
        AppNameContextHolder.setAppName((String)arg0.getJobParameter());
        DubboResult result = this.capacityAssessmentTaskApi.executionOrgManageInitData();
        log.info("org call executionMediationInitData result:{}", (Object)result);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)result.getMessage());
        ApplicableObjectEnums type = ApplicableObjectEnums.ORG_MANAGE;
        ExecutionCapacityAssessmentInitResDTO resDTO = (ExecutionCapacityAssessmentInitResDTO)result.getData();
        String startDate = CapacityAssessmentJobHandler.convertDateFormat(resDTO.getStartDate());
        String endDate = CapacityAssessmentJobHandler.convertDateFormat(resDTO.getEndDate());
        int pageSize = 100;
        int remainder = resDTO.getCount() % pageSize;
        int quotient = resDTO.getCount() / pageSize;
        int pageCount = remainder == 0 ? quotient : quotient + 1;
        log.info("orgCount is: {}, pageCount:{}", (Object)resDTO.getCount(), (Object)pageCount);
        ArrayList<MediationAssistStatisticsResDTO> listFromSelReferee = new ArrayList<MediationAssistStatisticsResDTO>();
        List<RefereeMediateStatiscsResDTO> listforReqUser = CapacityAssessmentJobHandler.convertRefereeOrgManageResultToReqData(listFromSelReferee);
        CapacityAssessmentTaskListReqDTO req = CapacityAssessmentJobHandler.buildCapacityAssessmentTaskListReqDTO(resDTO.getCount(), 1, pageSize, true, listforReqUser, type);
        DubboResult executionEvaluation = this.capacityAssessmentTaskApi.executionOrgManageEvaluation(req);
        log.info(executionEvaluation.toString());
        for (int i = 0; i < pageCount; ++i) {
            List data;
            if (!executionEvaluation.isSuccess()) {
                log.info("org call executionEvaluation faild");
                AssertUtils.assertFalse((boolean)result.isSuccess(), (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)result.getMessage());
            }
            if ((data = ((PageInfo)executionEvaluation.getData()).getList()) == null || data.size() == 0) {
                log.info("userId count 0, i value is {}", (Object)i);
                continue;
            }
            MediateStatisticsReqDTO reqDTO = new MediateStatisticsReqDTO();
            reqDTO.setEndDate(endDate);
            reqDTO.setStartDate(startDate);
            reqDTO.setOrgIds(data);
            DubboResult result2 = this.statementStatisticsApi.caseAssistStatisticsByMediatorHelpId(reqDTO);
            log.info("call referee {} complete", (Object)i);
            log.info("referee response msg is: {}", (Object)result2.toString());
            if (!result2.isSuccess()) {
                AssertUtils.assertFalse((boolean)result.isSuccess(), (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)result.getMessage());
            }
            listFromSelReferee.clear();
            ArrayList data2 = (ArrayList)result2.getData();
            listforReqUser = CapacityAssessmentJobHandler.convertRefereeOrgManageResultToReqData(data2);
            req = CapacityAssessmentJobHandler.buildCapacityAssessmentTaskListReqDTO(resDTO.getCount(), i + 2, pageSize, false, listforReqUser, type);
            executionEvaluation = this.capacityAssessmentTaskApi.executionOrgManageEvaluation(req);
        }
        DubboResult result2 = this.capacityAssessmentTaskApi.executionEvaluationComplete(req);
        log.info("Completion of Institutional Capacity Assessment", (Object)result2.toString());
    }
}

