/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.admin.schedule.util;

import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.Java8DateUtils;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class BaseUtils {
    public static final String DATE_FORMAT_SERIAL = "yyyyMMdd";
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    public static String getYesterdayDate(String start, String pattern) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(pattern);
        LocalDate startDate = LocalDate.parse(start, dateFormatter);
        LocalDate plusDays = startDate.minusDays(1L);
        return dateFormatter.format(plusDays);
    }

    public static String getDate(LocalDate date, String pattern) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(pattern);
        return dateFormatter.format(date);
    }

    public static List<String> getLarq() {
        ArrayList larqList = Lists.newArrayList();
        String today = Java8DateUtils.formatter((Date)new Date(), (String)DATE_FORMAT_SERIAL);
        String startDate = BaseUtils.getYesterdayDate(today, DATE_FORMAT_SERIAL);
        String larq = startDate + "-" + startDate;
        larqList.add(larq);
        return larqList;
    }

    public static LocalDate getLocalDate(String date, String pattern) {
        pattern = StringUtils.isBlank((CharSequence)pattern) ? DATE_FORMAT_SERIAL : pattern;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        LocalDate localDateTime = LocalDate.parse(date, formatter);
        return localDateTime;
    }

    public static List<String> checkParamLarq(String larq) {
        if (StringUtils.contains((CharSequence)larq, (CharSequence)"-") && StringUtils.length((CharSequence)StringUtils.trim((String)larq)) != 17 && StringUtils.indexOf((CharSequence)larq, (CharSequence)"-") != 8) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)DubboResultCodeEnums.PARAM_ERROR, (String)"\u7acb\u6848\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u683c\u5f0f\u5e94\u4e3a: yyyyMMdd-yyyyMMdd");
        }
        ArrayList larqList = Lists.newArrayList();
        String[] dates = larq.split("-");
        String pattern = DATE_FORMAT_SERIAL;
        LocalDate startDate = BaseUtils.getLocalDate(dates[0], pattern);
        LocalDate endDate = BaseUtils.getLocalDate(dates[1], pattern);
        long distance = ChronoUnit.DAYS.between(startDate, endDate);
        ArrayList list = Lists.newArrayList();
        if (distance < 1L) {
            endDate = startDate.plusDays(1L);
            String startDateStr = BaseUtils.getDate(startDate, pattern);
            String endDateStr = BaseUtils.getDate(endDate, pattern);
            String larqStr = startDateStr + "-" + endDateStr;
            larqList.add(larqStr);
        } else {
            int compareTo = startDate.compareTo(endDate);
            LocalDate minDate = compareTo > 0 ? endDate : startDate;
            Stream.iterate(minDate, d -> d.plusDays(1L)).limit(distance + 1L).forEach(f -> list.add(BaseUtils.getDate(f, pattern)));
            for (int i = 0; i < list.size(); ++i) {
                String start = (String)list.get(i);
                larqList.add(start + "-" + start);
            }
        }
        return larqList;
    }

    public static String getKtrq() {
        String startDate = Java8DateUtils.formatter((Date)new Date(), (String)DATE_FORMAT_SERIAL);
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(DATE_FORMAT_SERIAL);
        LocalDate localDate = LocalDate.parse(startDate, dateFormatter);
        LocalDate plusDays = localDate.plusDays(6L);
        String endDate = dateFormatter.format(plusDays);
        return startDate + "-" + endDate;
    }

    public static String getFormatDate(Date date) {
        String nowDate = Java8DateUtils.formatter((Date)date, (String)DATE_FORMAT);
        return nowDate;
    }

    public static String getPlusDay(Date date, long daysToAdd) {
        String nowDate = Java8DateUtils.formatter((Date)date, (String)DATE_FORMAT);
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(DATE_FORMAT);
        LocalDate localDate = LocalDate.parse(nowDate, dateFormatter);
        LocalDate plusDays = localDate.plusDays(daysToAdd);
        String timeToAdd = dateFormatter.format(plusDays);
        return timeToAdd;
    }
}

