/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.admin.schedule.user;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.admin.feign.appeal.HandlerTaskServiceApiFeign;
import com.beiming.odr.admin.feign.referee.StatementStatisticsApiFeign;
import com.beiming.odr.admin.feign.user.CapacityAssessmentTaskApiFeign;
import com.beiming.odr.admin.schedule.handler.CapacityAssessmentJobHandler;
import com.beiming.odr.appeal.api.dto.response.AppealHandlerStatiscsResDTO;
import com.beiming.odr.referee.dto.requestdto.MediateStatisticsReqDTO;
import com.beiming.odr.user.api.common.enums.ApplicableObjectEnums;
import com.beiming.odr.user.api.dto.requestdto.CapacityAssessmentTaskListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RefereeMediateStatiscsResDTO;
import com.beiming.odr.user.api.dto.responsedto.HandlerCapacityAssessmentInitResDTO;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CapacityAssessmentHandlerJob
implements SimpleJob {
    private static final Logger log = LoggerFactory.getLogger(CapacityAssessmentHandlerJob.class);
    @Resource
    StatementStatisticsApiFeign statementStatisticsApi;
    @Resource
    CapacityAssessmentTaskApiFeign capacityAssessmentTaskApi;
    @Resource
    HandlerTaskServiceApiFeign appealHeaderServiceApi;

    public void execute(ShardingContext arg0) {
        log.info("CapacityAssessmentHandlerJob start");
        AppNameContextHolder.setAppName((String)arg0.getJobParameter());
        DubboResult result = this.capacityAssessmentTaskApi.executionHandlerInitData();
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)result.getMessage());
        ApplicableObjectEnums type = ApplicableObjectEnums.APPEAL_HANDLER;
        HandlerCapacityAssessmentInitResDTO resDTO = (HandlerCapacityAssessmentInitResDTO)result.getData();
        String startDate = CapacityAssessmentJobHandler.convertDateFormat(resDTO.getStartDate());
        String endDate = CapacityAssessmentJobHandler.convertDateFormat(resDTO.getEndDate());
        int pageSize = 10;
        int remainder = ((HandlerCapacityAssessmentInitResDTO)result.getData()).getUserids().size() % pageSize;
        int quotient = ((HandlerCapacityAssessmentInitResDTO)result.getData()).getUserids().size() / pageSize;
        int pageCount = remainder == 0 ? quotient : quotient + 1;
        log.info("=============size()==================" + ((HandlerCapacityAssessmentInitResDTO)result.getData()).getUserids().size() + pageCount);
        DubboResult result1 = this.appealHeaderServiceApi.countEveryHandeler(resDTO.getUserids(), startDate, endDate);
        ArrayList<RefereeMediateStatiscsResDTO> templist = new ArrayList<RefereeMediateStatiscsResDTO>();
        for (int i = 0; i < ((ArrayList)result1.getData()).size(); ++i) {
            RefereeMediateStatiscsResDTO refereeMediateStatiscsResDTO = new RefereeMediateStatiscsResDTO();
            refereeMediateStatiscsResDTO.setMediatorId(Long.valueOf(((AppealHandlerStatiscsResDTO)((ArrayList)result1.getData()).get(i)).getUserId()));
            refereeMediateStatiscsResDTO.setSuccessNum(((AppealHandlerStatiscsResDTO)((ArrayList)result1.getData()).get(i)).getSuccessNum());
            refereeMediateStatiscsResDTO.setStartNum(((AppealHandlerStatiscsResDTO)((ArrayList)result1.getData()).get(i)).getIngNum());
            refereeMediateStatiscsResDTO.setFailNum(((AppealHandlerStatiscsResDTO)((ArrayList)result1.getData()).get(i)).getFailNum());
            templist.add(refereeMediateStatiscsResDTO);
        }
        CapacityAssessmentTaskListReqDTO req = CapacityAssessmentJobHandler.buildCapacityAssessmentTaskListReqDTO(templist.size(), 1, 10, true, templist, type);
        log.info("@@@@@@@@ call Capaci" + req.toString());
        DubboResult executionEvaluation = this.capacityAssessmentTaskApi.executionEvaluation(req);
        for (int i = 0; i < pageCount; ++i) {
            List data;
            if (!executionEvaluation.isSuccess()) {
                log.info("m call executionEvaluation faild");
                AssertUtils.assertFalse((boolean)result.isSuccess(), (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)result.getMessage());
            }
            if ((data = ((PageInfo)executionEvaluation.getData()).getList()) == null || data.size() == 0) {
                log.info("userId count 0, i value is {}", (Object)i);
                continue;
            }
            MediateStatisticsReqDTO reqDTO = new MediateStatisticsReqDTO();
            reqDTO.setEndDate(endDate);
            reqDTO.setStartDate(startDate);
            reqDTO.setMediatorIds(((PageInfo)executionEvaluation.getData()).getList());
            executionEvaluation = this.capacityAssessmentTaskApi.executionEvaluation(req);
        }
        this.capacityAssessmentTaskApi.executionEvaluationComplete(req);
    }
}

