/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.admin.schedule.user;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.admin.feign.referee.StatementStatisticsApiFeign;
import com.beiming.odr.admin.feign.user.CapacityAssessmentTaskApiFeign;
import com.beiming.odr.admin.schedule.handler.CapacityAssessmentJobHandler;
import com.beiming.odr.referee.dto.requestdto.MediateStatisticsReqDTO;
import com.beiming.odr.user.api.common.enums.ApplicableObjectEnums;
import com.beiming.odr.user.api.dto.requestdto.CapacityAssessmentTaskListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RefereeMediateStatiscsResDTO;
import com.beiming.odr.user.api.dto.responsedto.ExecutionCapacityAssessmentInitResDTO;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CapacityAssessmentOrgJob
implements SimpleJob {
    private static final Logger log = LoggerFactory.getLogger(CapacityAssessmentOrgJob.class);
    @Resource
    CapacityAssessmentTaskApiFeign capacityAssessmentTaskApi;
    @Resource
    StatementStatisticsApiFeign statementStatisticsApi;

    public void execute(ShardingContext arg0) {
        String jobParameter = arg0.getJobParameter();
        log.info("jobParameter is : {}", (Object)jobParameter);
        AppNameContextHolder.setAppName((String)arg0.getJobParameter());
        DubboResult result = this.capacityAssessmentTaskApi.executionOrgInitData();
        log.info("org call executionMediationInitData result:{}", (Object)result);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)result.getMessage());
        ApplicableObjectEnums type = ApplicableObjectEnums.ORG;
        ExecutionCapacityAssessmentInitResDTO resDTO = (ExecutionCapacityAssessmentInitResDTO)result.getData();
        String startDate = CapacityAssessmentJobHandler.convertDateFormat(resDTO.getStartDate());
        String endDate = CapacityAssessmentJobHandler.convertDateFormat(resDTO.getEndDate());
        int pageSize = 100;
        int remainder = resDTO.getCount() % pageSize;
        int quotient = resDTO.getCount() / pageSize;
        int pageCount = remainder == 0 ? quotient : quotient + 1;
        log.info("orgCount is: {}, pageCount:{}", (Object)resDTO.getCount(), (Object)pageCount);
        ArrayList listFromSelReferee = new ArrayList();
        List<RefereeMediateStatiscsResDTO> listforReqUser = CapacityAssessmentJobHandler.convertRefereeResultToReqData(listFromSelReferee);
        CapacityAssessmentTaskListReqDTO req = CapacityAssessmentJobHandler.buildCapacityAssessmentTaskListReqDTO(resDTO.getCount(), 1, pageSize, true, listforReqUser, type);
        DubboResult executionEvaluation = this.capacityAssessmentTaskApi.executionEvaluation(req);
        log.info(executionEvaluation.toString());
        for (int i = 0; i < pageCount; ++i) {
            List data;
            if (!executionEvaluation.isSuccess()) {
                log.info("org call executionEvaluation faild");
                AssertUtils.assertFalse((boolean)result.isSuccess(), (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)result.getMessage());
            }
            if ((data = ((PageInfo)executionEvaluation.getData()).getList()) == null || data.size() == 0) {
                log.info("userId count 0, i value is {}", (Object)i);
                continue;
            }
            MediateStatisticsReqDTO reqDTO = new MediateStatisticsReqDTO();
            reqDTO.setEndDate(endDate);
            reqDTO.setStartDate(startDate);
            reqDTO.setOrgIds(data);
            DubboResult resultFromReferee = this.statementStatisticsApi.caseStatisticsByOrgId(reqDTO);
            log.info("call referee {} complete", (Object)i);
            log.info("referee response msg is: {}", (Object)resultFromReferee.toString());
            if (!resultFromReferee.isSuccess()) {
                AssertUtils.assertFalse((boolean)result.isSuccess(), (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)result.getMessage());
            }
            listFromSelReferee.clear();
            listFromSelReferee = (ArrayList)resultFromReferee.getData();
            listforReqUser = CapacityAssessmentJobHandler.convertRefereeResultToReqData(listFromSelReferee);
            req = CapacityAssessmentJobHandler.buildCapacityAssessmentTaskListReqDTO(resDTO.getCount(), i + 2, pageSize, false, listforReqUser, type);
            executionEvaluation = this.capacityAssessmentTaskApi.executionEvaluation(req);
        }
        DubboResult result2 = this.capacityAssessmentTaskApi.executionEvaluationComplete(req);
        log.info("Completion of Institutional Capacity Assessment", (Object)result2.toString());
    }
}

