/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.admin.schedule.user;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.admin.feign.user.OrderCaseNumberServiceApiFeign;
import com.beiming.odr.referee.api.MediationInfoApi;
import com.beiming.odr.referee.dto.CountDTO;
import com.beiming.odr.user.api.dto.requestdto.UpdateOrderCaseNumberReqDTO;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OrderCaseNumberJob
implements SimpleJob {
    private static final Logger log = LoggerFactory.getLogger(OrderCaseNumberJob.class);
    @Resource
    private MediationInfoApi mediationInfoApi;
    @Resource
    private OrderCaseNumberServiceApiFeign orderCaseNumberServiceApi;
    private static final String ORG_TYPE = "ORGANIZATION";
    private static final String MEDIATOR_TYPE = "MEDIATOR";

    public void execute(ShardingContext context) {
        DubboResult mediatorResult;
        log.info("OrderCaseNumberJob run....");
        String appName = context.getJobParameter();
        AppNameContextHolder.setAppName((String)appName);
        ArrayList<UpdateOrderCaseNumberReqDTO> orgList = new ArrayList<UpdateOrderCaseNumberReqDTO>();
        ArrayList<UpdateOrderCaseNumberReqDTO> mediatorList = new ArrayList<UpdateOrderCaseNumberReqDTO>();
        DubboResult orgResult = this.mediationInfoApi.countByOrgId();
        if (orgResult.isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)((Object)orgResult.getData())))) {
            for (CountDTO countDTO : (ArrayList)orgResult.getData()) {
                UpdateOrderCaseNumberReqDTO caseNumberReqDTO = new UpdateOrderCaseNumberReqDTO();
                caseNumberReqDTO.setSubjectId(Long.valueOf(countDTO.getId()));
                caseNumberReqDTO.setSubjectType(ORG_TYPE);
                caseNumberReqDTO.setCaseNumber(countDTO.getNum());
                orgList.add(caseNumberReqDTO);
            }
        }
        if ((mediatorResult = this.mediationInfoApi.countByMediatorId()).isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)((Object)mediatorResult.getData())))) {
            for (CountDTO countDTO : (ArrayList)mediatorResult.getData()) {
                UpdateOrderCaseNumberReqDTO caseNumberReqDTO = new UpdateOrderCaseNumberReqDTO();
                caseNumberReqDTO.setSubjectId(Long.valueOf(countDTO.getId()));
                caseNumberReqDTO.setSubjectType(MEDIATOR_TYPE);
                caseNumberReqDTO.setCaseNumber(countDTO.getNum());
                mediatorList.add(caseNumberReqDTO);
            }
        }
        if (!CollectionUtils.isEmpty(orgList)) {
            this.orderCaseNumberServiceApi.updateOrderCaseNumber(orgList);
        }
        if (!CollectionUtils.isEmpty(mediatorList)) {
            this.orderCaseNumberServiceApi.updateOrderCaseNumber(mediatorList);
        }
        log.info("OrderCaseNumberJob end....");
    }
}

