/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.admin.schedule.user;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.AppNameEnums;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.admin.feign.user.UserReportServiceApiFeign;
import com.beiming.odr.user.api.dto.requestdto.UserReportReqDTO;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import java.time.LocalDate;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UserReportJob
implements SimpleJob {
    private static final Logger log = LoggerFactory.getLogger(UserReportJob.class);
    @Resource
    private UserReportServiceApiFeign userReportServiceApi;
    @Value(value="${areaCode.yunnan}")
    private String yunnanAreaCode;
    @Value(value="${areaCode.zhengzhou}")
    private String zhengzhouAreaCode;
    @Value(value="${areaCode.shiJingShan}")
    private String shiJingShanAreaCode;
    @Value(value="${areaCode.guiyang}")
    private String guiyangAreaCode;

    public void execute(ShardingContext context) {
        log.info("UserReportJob run....");
        String appName = context.getJobParameter();
        AppNameContextHolder.setAppName((String)appName);
        UserReportReqDTO userReportReqDTO = new UserReportReqDTO();
        String beforeWeekDayString = LocalDate.now().minusDays(8L).toString();
        String yesterdayString = LocalDate.now().minusDays(1L).toString();
        userReportReqDTO.setStartDate(beforeWeekDayString);
        userReportReqDTO.setEndDate(yesterdayString);
        if (AppNameEnums.YNODR.name().equalsIgnoreCase(appName)) {
            userReportReqDTO.setAreaCode(this.yunnanAreaCode);
        } else if (AppNameEnums.ZHENGZHOUODR.name().equalsIgnoreCase(appName)) {
            userReportReqDTO.setAreaCode(this.zhengzhouAreaCode);
        } else if (AppNameEnums.GUIYANGODR.name().equalsIgnoreCase(appName)) {
            userReportReqDTO.setAreaCode(this.guiyangAreaCode);
        } else {
            userReportReqDTO.setAreaCode(this.shiJingShanAreaCode);
        }
        DubboResult result = this.userReportServiceApi.getUserReport(userReportReqDTO, false);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)"\u6267\u884c\u67e5\u8be2\u7528\u6237\u7edf\u8ba1\u62a5\u8868\u51fa\u9519");
        log.info("UserReportJob end....");
    }
}

