/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.admin.schedule.referee;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.referee.api.StatementStatisticsApi;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import java.time.LocalDate;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RefereeLawCaseStatisticsJob
implements SimpleJob {
    private static final Logger log = LoggerFactory.getLogger(RefereeLawCaseStatisticsJob.class);
    @Resource
    private StatementStatisticsApi statementStatisticsApi;

    public void execute(ShardingContext shardingContext) {
        log.info("RefereeLawCaseStatisticsJob run....");
        AppNameContextHolder.setAppName((String)shardingContext.getJobParameter());
        String startDate = LocalDate.now().minusDays(8L).toString();
        String endDate = LocalDate.now().minusDays(1L).toString();
        DubboResult dubboResult = this.statementStatisticsApi.everyDayTaskStatisticsList(startDate, endDate);
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)String.format("\u6267\u884c\u8c03\u89e3\u6848\u4ef6\u6570\u91cf\u7edf\u8ba1\u5931\u8d25, \u5f53\u524d\u65e5\u671f\u662f: %s", LocalDate.now().toString()));
        log.info("RefereeLawCaseStatisticsJob end....");
    }
}

