/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.job.config;

import com.beiming.odr.job.service.ElasticJobListener;
import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.event.rdb.JobEventRdbConfiguration;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperConfiguration;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperRegistryCenter;
import javax.annotation.Resource;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="elasticjob")
public class ElasticJobConfig {
    private String serverLists;
    private String namespace;
    @Resource
    private DataSource dataSource;

    @Bean
    public ZookeeperConfiguration zkConfig() {
        return new ZookeeperConfiguration(this.serverLists, this.namespace);
    }

    @Bean(initMethod="init")
    public ZookeeperRegistryCenter regCenter(ZookeeperConfiguration config) {
        return new ZookeeperRegistryCenter(config);
    }

    @Bean
    public JobEventConfiguration jobEventConfiguration() {
        return new JobEventRdbConfiguration((javax.sql.DataSource)this.dataSource);
    }

    @Bean
    public ElasticJobListener elasticJobListener() {
        return new ElasticJobListener(0L, 0L);
    }

    public String getServerLists() {
        return this.serverLists;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setServerLists(String serverLists) {
        this.serverLists = serverLists;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticJobConfig)) {
            return false;
        }
        ElasticJobConfig other = (ElasticJobConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$serverLists = this.getServerLists();
        String other$serverLists = other.getServerLists();
        if (this$serverLists == null ? other$serverLists != null : !this$serverLists.equals(other$serverLists)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        return !(this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticJobConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverLists = this.getServerLists();
        result = result * 59 + ($serverLists == null ? 43 : $serverLists.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        return result;
    }

    public String toString() {
        return "ElasticJobConfig(serverLists=" + this.getServerLists() + ", namespace=" + this.getNamespace() + ", dataSource=" + this.getDataSource() + ")";
    }
}

