/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.io.IOUtils;

public class RSAUtil {
    public static final String CHARSET = "UTF-8";
    public static final String RSA_ALGORITHM = "RSA";

    public static Map<String, String> generateKeys(int keySize) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA_ALGORITHM);
            keyPairGenerator.initialize(keySize);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            HashMap<String, String> keyPairMap = new HashMap<String, String>();
            keyPairMap.put("sfdsj@Bm0601", RSAUtil.encodeBase64(publicKey.getEncoded()));
            keyPairMap.put("ssfw@Bm0601", RSAUtil.encodeBase64(privateKey.getEncoded()));
            return keyPairMap;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException("generate rsa keys error.");
        }
    }

    public static String publicEncrypt(String data, String publicKeyStr) {
        try {
            RSAPublicKey publicKey = RSAUtil.getPublicKey(publicKeyStr);
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(1, publicKey);
            return RSAUtil.encodeBase64(RSAUtil.rsaSplitCodec(cipher, 1, data.getBytes(CHARSET), publicKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32:" + data + "\u5f02\u5e38", e);
        }
    }

    public static String privateDecrypt(String data, String privateKeyStr) {
        try {
            RSAPrivateKey privateKey = RSAUtil.getPrivateKey(privateKeyStr);
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(2, privateKey);
            return new String(RSAUtil.rsaSplitCodec(cipher, 2, Base64.getDecoder().decode(data), privateKey.getModulus().bitLength()), CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5b57\u7b26\u4e32:" + data + "\u5f02\u5e38", e);
        }
    }

    public static String privateEncrypt(String data, String privateKeyStr) {
        try {
            RSAPrivateKey privateKey = RSAUtil.getPrivateKey(privateKeyStr);
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(1, privateKey);
            return RSAUtil.encodeBase64(RSAUtil.rsaSplitCodec(cipher, 1, data.getBytes(CHARSET), privateKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String publicDecrypt(String data, String publicKeyStr) {
        try {
            RSAPublicKey publicKey = RSAUtil.getPublicKey(publicKeyStr);
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(2, publicKey);
            return new String(RSAUtil.rsaSplitCodec(cipher, 2, Base64.getDecoder().decode(data), publicKey.getModulus().bitLength()), CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5b57\u7b26\u4e32:" + data + "\u5f02\u5e38", e);
        }
    }

    private static RSAPublicKey getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKey));
        RSAPublicKey key = (RSAPublicKey)keyFactory.generatePublic(x509KeySpec);
        return key;
    }

    private static RSAPrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey));
        RSAPrivateKey key = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        return key;
    }

    private static byte[] rsaSplitCodec(Cipher cipher, int opmode, byte[] datas, int keySize) {
        int maxBlock = 0;
        maxBlock = opmode == 2 ? keySize / 8 : keySize / 8 - 11;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        try {
            while (datas.length > offSet) {
                byte[] buff = datas.length - offSet > maxBlock ? cipher.doFinal(datas, offSet, maxBlock) : cipher.doFinal(datas, offSet, datas.length - offSet);
                out.write(buff, 0, buff.length);
                offSet = ++i * maxBlock;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u89e3\u5bc6\u9600\u503c\u4e3a[" + maxBlock + "]\u7684\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
        byte[] resultDatas = out.toByteArray();
        IOUtils.closeQuietly((OutputStream)out);
        return resultDatas;
    }

    private static String encodeBase64(byte[] bytes) {
        return new String(Base64.getEncoder().encode(bytes));
    }

    private static String decodeBase64(byte[] bytes) {
        return new String(Base64.getDecoder().decode(bytes));
    }

    public static void main(String[] args) {
        String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCRnIjhXaIwPynguW3253X7W04BK9ck0TizTSt+OXHDCKEPbHOr8fqjg6CBQmQz1rteGJ1Aqk0Hw3PXoi5QRb+XGpMktEsP99RMb1JMyrZbP2hoGiMbgHtokBqDIfDFOmT5VimiXf+SJv9DnDYML2YPayMdtG40jUZjXayIcwNT2wIDAQAB";
        String password = "uasp";
        String mw = RSAUtil.publicEncrypt(password, publicKey);
        System.out.println(mw);
        String mw11 = RSAUtil.encodeBase64(mw.getBytes(StandardCharsets.UTF_8));
        System.out.println(mw11);
    }
}

