/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static String encoding = "UTF-8";
    private static Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);
    private static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();

    public static String sendHttpPost(String httpUrl) throws IOException {
        HttpPost httpPost = new HttpPost(httpUrl);
        return HttpClientUtils.sendHttpPost(httpPost);
    }

    public static String sendHttpPost(String httpUrl, String json) throws IOException {
        HttpPost httpPost = new HttpPost(httpUrl);
        httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        return HttpClientUtils.sendHttpPost(httpPost);
    }

    public static String sendHttpPost(String httpUrl, String json, String token) throws IOException {
        HttpPost httpPost = new HttpPost(httpUrl);
        httpPost.setHeader("token", token);
        httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        return HttpClientUtils.sendHttpPost(httpPost);
    }

    public static String sendHttpPostAuthorization(String httpUrl, String json, String authorization) throws IOException {
        HttpPost httpPost = new HttpPost(httpUrl);
        httpPost.setHeader("authorization", authorization);
        httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        return HttpClientUtils.sendHttpPost(httpPost);
    }

    public static String sendHttpPost(String httpUrl, String json, String key, String token) throws IOException {
        HttpPost httpPost = new HttpPost(httpUrl);
        httpPost.setHeader("key", key);
        httpPost.setHeader("token", token);
        httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        return HttpClientUtils.sendHttpPost(httpPost);
    }

    public static String sendHttpPostByUserName(String httpUrl, String userName, String password) throws IOException {
        HttpPost httpPost = new HttpPost(httpUrl);
        httpPost.setHeader("userName", userName);
        httpPost.setHeader("password", password);
        return HttpClientUtils.sendHttpPost(httpPost);
    }

    public static String sendHttpPost(String httpUrl, Map<String, String> maps) throws IOException {
        HttpPost httpPost = new HttpPost(httpUrl);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (String key : maps.keySet()) {
            nameValuePairs.add(new BasicNameValuePair(key, maps.get(key)));
        }
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, encoding));
        }
        catch (Exception e) {
            logger.error("HttpClientUtils sendHttpPost error {}");
        }
        return HttpClientUtils.sendHttpPost(httpPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendHttpPost(HttpPost httpPost) throws IOException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            httpClient = HttpClients.createDefault();
            httpPost.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpPost);
            entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)encoding);
        }
        catch (Exception e) {
            logger.error("HttpClientUtils sendHttpPost error {}", (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return responseContent;
    }

    public static String sendHttpGet(String httpUrl) throws IOException {
        HttpGet httpGet = new HttpGet(httpUrl);
        return HttpClientUtils.sendHttpGet(httpGet);
    }

    public static String sendHttpsGet(String httpUrl) throws IOException {
        HttpGet httpGet = new HttpGet(httpUrl);
        return HttpClientUtils.sendHttpsGet(httpGet);
    }

    public static String sendHttpGet(String httpUrl, Map<String, String> header) throws IOException {
        HttpGet httpGet = new HttpGet(httpUrl);
        if (header != null) {
            Set<String> keys = header.keySet();
            for (String key : keys) {
                httpGet.setHeader(key, header.get(key));
            }
        }
        return HttpClientUtils.sendHttpGet(httpGet);
    }

    public static String sendHttpsGet(String httpUrl, Map<String, String> header) throws IOException {
        HttpGet httpGet = new HttpGet(httpUrl);
        if (header != null) {
            Set<String> keys = header.keySet();
            for (String key : keys) {
                httpGet.setHeader(key, header.get(key));
            }
        }
        return HttpClientUtils.sendHttpsGet(httpGet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendHttpsGet(HttpGet httpGet) throws IOException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)SSLConnectionSocketFactory.getSocketFactory()).setDefaultRequestConfig(requestConfig).build();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)encoding);
        }
        catch (Exception e) {
            logger.error("HttpClientUtils sendHttpsGet error {}", (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return responseContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendHttpGet(HttpGet httpGet) throws IOException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            httpClient = HttpClients.createDefault();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)encoding);
        }
        catch (Exception e) {
            logger.error("HttpClientUtils sendHttpsGet error {}", (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return responseContent;
    }

    public static String sendHttpPostHead(String httpUrl, String json, JSONObject head) throws IOException {
        HttpPost httpPost = new HttpPost(httpUrl);
        httpPost.addHeader("Cmd", head.getString("Cmd"));
        httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        return HttpClientUtils.sendHttpPost(httpPost);
    }

    public static void main(String[] args) {
    }
}

