/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.common.utils;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.odr.document.enums.CaseUserTypeEnum;
import com.beiming.odr.document.enums.DocumentTypeEnum;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import java.util.HashSet;
import java.util.Set;

public class WeitingshenUtil {
    public static final String WEITINGSHEN_APPNAME = "weitingshen";
    public static final String WEITINGSHEN_APPNAME_HUBEI = "weitingshenhubei";
    public static final String WEITINGSHEN_APPNAME_HAINAN = "weitingshenhainan";
    public static final String WEITINGSHEN_APPNAME_HUBEI_ZZ = "weitingshenhubeizz";
    public static final String WEITINGSHEN_APPNAME_SHAANXI = "weitingshensx";
    public static final String WEITINGSHEN_APPNAME_YANCHENG = "weitingshenyc";
    public static final String ABSENT_LITIGAT_PHONE_NO = "1111";

    public static String individualizationPersonName(CaseUserTypeEnum caseUserType) {
        String weitingshenAppName = WEITINGSHEN_APPNAME;
        String appName = AppNameContextHolder.getAppName();
        if (appName.contains(weitingshenAppName) && CaseUserTypeEnum.MEDIATOR.equals((Object)caseUserType)) {
            return "\u6cd5\u5b98";
        }
        if (appName.contains(weitingshenAppName) && CaseUserTypeEnum.RESPONDENT.equals((Object)caseUserType)) {
            return "\u88ab\u544a";
        }
        if (appName.contains(weitingshenAppName) && CaseUserTypeEnum.APPLICANT.equals((Object)caseUserType)) {
            return "\u539f\u544a";
        }
        if (appName.contains(weitingshenAppName) && CaseUserTypeEnum.RESPONDENT_AGENT.equals((Object)caseUserType)) {
            return "\u88ab\u544a\u4ee3\u7406\u4eba";
        }
        if (appName.contains(weitingshenAppName) && CaseUserTypeEnum.APPLICANT_AGENT.equals((Object)caseUserType)) {
            return "\u539f\u544a\u4ee3\u7406\u4eba";
        }
        return caseUserType.getName();
    }

    public static String individualizationDocumentTypeName(DocumentTypeEnum documentType) {
        String docTypeName = documentType.getName();
        if (WeitingshenUtil.isWeitingshenSeriesAppName().booleanValue()) {
            docTypeName = DocumentTypeEnum.MEDIATION_RECORD.equals((Object)documentType) ? "\u7b14\u5f55" : docTypeName;
            docTypeName = DocumentTypeEnum.INQUIRE_RECORD.equals((Object)documentType) ? "\u7b14\u5f55" : docTypeName;
        }
        return docTypeName;
    }

    public static Boolean isWeitingshenSeriesAppName() {
        String appName = AppNameContextHolder.getAppName();
        return appName.contains(WEITINGSHEN_APPNAME);
    }

    public static Boolean appNameEqualWeitingshenHuBei() {
        String appName = AppNameContextHolder.getAppName();
        return appName.equals(WEITINGSHEN_APPNAME_HUBEI);
    }

    public static Boolean appNameEqualWeitingshenHaiNan() {
        String appName = AppNameContextHolder.getAppName();
        return appName.equals(WEITINGSHEN_APPNAME_HAINAN);
    }

    public static Boolean appNameEqualWeitingshenHuBeiZz() {
        String appName = AppNameContextHolder.getAppName();
        return appName.equals(WEITINGSHEN_APPNAME_HUBEI_ZZ);
    }

    public static Boolean appNameEqualWeitingshenShaanXi() {
        String appName = AppNameContextHolder.getAppName();
        return appName.equals(WEITINGSHEN_APPNAME_SHAANXI);
    }

    public static Boolean appNameEqualWeitingshenYanCheng() {
        String appName = AppNameContextHolder.getAppName();
        return appName.equals(WEITINGSHEN_APPNAME_YANCHENG);
    }

    public static Set<MeetingUserTypeEnum> getLitigatSet() {
        HashSet<MeetingUserTypeEnum> set = new HashSet<MeetingUserTypeEnum>();
        set.add(MeetingUserTypeEnum.APPLICANT);
        set.add(MeetingUserTypeEnum.LITIGANT);
        set.add(MeetingUserTypeEnum.RESPONDENT);
        set.add(MeetingUserTypeEnum.LITIGANT_THIRD);
        set.add(MeetingUserTypeEnum.LITIGANT_SURVEYOR);
        set.add(MeetingUserTypeEnum.LITIGANT_TRANSLATOR);
        return set;
    }
}

