/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.common.utils.sm4.hainanrequestdto.SM4ECBDecrptyRequestDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanrequestdto.SM4ECBEncryptRequestDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanrequestdto.SM4MACDecryptRequestDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanrequestdto.SM4MACEncryptRequestDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanresponsedto.SM4ECBDecryptResponseDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanresponsedto.SM4ECBEncryptResponseDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanresponsedto.SM4MACDecryptResponseDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanresponsedto.SM4MACEncryptResponseDTO;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SM4ECBAndMACUtils {
    private static final Logger log = LoggerFactory.getLogger(SM4ECBAndMACUtils.class);
    @Value(value="${hainanodr.sm4.sm4keycode}")
    private String sm4keycode;
    @Value(value="${hainanodr.sm4.mackeycode}")
    private String mackeycode;
    @Value(value="${hainanodr.sm4.xIcspTenantCode}")
    private String xIcspTenantCode;
    @Value(value="${hainanodr.sm4.authorization}")
    private String authorization;
    @Value(value="${hainanodr.sm4.password}")
    private String password;
    @Value(value="${hainanodr.sm4.applicationIdentification}")
    private String applicationIdentification;
    @Value(value="${hainanodr.sm4.ecbEncryptUrl}")
    private String ecbEncryptUrl;
    @Value(value="${hainanodr.sm4.ecbDecryptUrl}")
    private String ecbDecryptUrl;
    @Value(value="${hainanodr.sm4.macEncryptUrl}")
    private String macEncryptUrl;
    @Value(value="${hainanodr.sm4.macDecryptUrl}")
    private String macDecryptUrl;
    @Value(value="${spring.profiles.active}")
    private String profileActive;
    private static String staticSm4keycode;
    private static String staticMackeycode;
    private static String staticXIcspTenantCode;
    private static String staticAuthorization;
    private static String staticPassword;
    private static String staticApplicationIdentification;
    private static String staticEcbEncryptUrl;
    private static String staticEcbDecryptUrl;
    private static String staticMacEncryptUrl;
    private static String staticMacDecryptUrl;
    private static String staticProfileActive;
    private static int maxRetries;
    private static RequestConfig requestConfig;

    @PostConstruct
    public void init() {
        staticSm4keycode = this.sm4keycode;
        staticMackeycode = this.mackeycode;
        staticXIcspTenantCode = this.xIcspTenantCode;
        staticAuthorization = this.authorization;
        staticPassword = this.password;
        staticApplicationIdentification = this.applicationIdentification;
        staticEcbEncryptUrl = this.ecbEncryptUrl;
        staticEcbDecryptUrl = this.ecbDecryptUrl;
        staticMacEncryptUrl = this.macEncryptUrl;
        staticMacDecryptUrl = this.macDecryptUrl;
        staticProfileActive = this.profileActive;
    }

    public static String getStaticSm4KeyCode() {
        return staticSm4keycode;
    }

    public static String getStaticMackeycode() {
        return staticMackeycode;
    }

    public static String getStaticXIcspTenantCode() {
        return staticXIcspTenantCode;
    }

    public static String getStaticAuthorization() {
        return staticAuthorization;
    }

    public static String getPassword() {
        return staticPassword;
    }

    public static String getStaticApplicationIdentification() {
        return staticApplicationIdentification;
    }

    public static String getStaticEcbEncryptUrl() {
        return staticEcbEncryptUrl;
    }

    public static String getStaticEcbDecryptUrl() {
        return staticEcbDecryptUrl;
    }

    public static String getStaticMacEncryptUrl() {
        return staticMacEncryptUrl;
    }

    public static String getStaticMacDecryptUrl() {
        return staticMacDecryptUrl;
    }

    public static String getStaticProfileActive() {
        return staticProfileActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SM4ECBEncryptResponseDTO sm4ECBEncrypt(SM4ECBEncryptRequestDTO dto) throws IOException {
        int retryCount = 0;
        String json = JSONObject.toJSONString((Object)dto);
        log.info("SM4ECB\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)json);
        while (retryCount < maxRetries) {
            CloseableHttpClient httpClient = null;
            CloseableHttpResponse response = null;
            HttpEntity entity = null;
            HttpPost post = new HttpPost(SM4ECBAndMACUtils.getStaticEcbEncryptUrl());
            post.setHeader("Authorization", SM4ECBAndMACUtils.getStaticAuthorization());
            post.setHeader("X-ICSP-Tenant-Code", SM4ECBAndMACUtils.getStaticXIcspTenantCode());
            post.setHeader("Content-type", "application/json");
            StringEntity stringEntity = new StringEntity(json, "UTF-8");
            stringEntity.setContentType("application/json");
            post.setEntity((HttpEntity)stringEntity);
            if ("dacs".equals(SM4ECBAndMACUtils.getStaticProfileActive())) {
                log.info("url:{}, authorization:{}, x-icsp-tenant-code:{}", new Object[]{SM4ECBAndMACUtils.getStaticEcbEncryptUrl(), SM4ECBAndMACUtils.getStaticAuthorization(), SM4ECBAndMACUtils.getStaticXIcspTenantCode()});
                return null;
            }
            try {
                String code;
                httpClient = HttpClients.createDefault();
                post.setConfig(requestConfig);
                response = httpClient.execute((HttpUriRequest)post);
                entity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)entity);
                log.info("SM4ECB\u52a0\u5bc6\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String string = code = jsonObject.containsKey((Object)"code") ? jsonObject.getString("code") : "";
                if ("0".equals(code)) {
                    SM4ECBEncryptResponseDTO sm4ECBEncryptResponseDTO;
                    SM4ECBEncryptResponseDTO sM4ECBEncryptResponseDTO = sm4ECBEncryptResponseDTO = (SM4ECBEncryptResponseDTO)jsonObject.toJavaObject(SM4ECBEncryptResponseDTO.class);
                    return sM4ECBEncryptResponseDTO;
                }
                SM4ECBEncryptResponseDTO sM4ECBEncryptResponseDTO = null;
                return sM4ECBEncryptResponseDTO;
            }
            catch (Exception e) {
                AssertUtils.assertFalse((++retryCount >= maxRetries ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("SM4ECB\u52a0\u5bc6\u5931\u8d25\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a" + retryCount));
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (httpClient == null) continue;
                httpClient.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SM4ECBDecryptResponseDTO sm4ECBDecrypt(SM4ECBDecrptyRequestDTO dto) throws IOException {
        int retryCount = 0;
        String json = JSONObject.toJSONString((Object)dto);
        log.info("SM4ECB\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)json);
        while (retryCount < maxRetries) {
            CloseableHttpClient httpClient = null;
            CloseableHttpResponse response = null;
            HttpEntity entity = null;
            HttpPost post = new HttpPost(SM4ECBAndMACUtils.getStaticEcbDecryptUrl());
            post.setHeader("Authorization", SM4ECBAndMACUtils.getStaticAuthorization());
            post.setHeader("X-ICSP-Tenant-Code", SM4ECBAndMACUtils.getStaticXIcspTenantCode());
            post.setHeader("Content-type", "application/json");
            StringEntity stringEntity = new StringEntity(json, "UTF-8");
            stringEntity.setContentType("application/json");
            post.setEntity((HttpEntity)stringEntity);
            if ("dacs".equals(SM4ECBAndMACUtils.getStaticProfileActive())) {
                log.info("url:{}, authorization:{}, x-icsp-tenant-code:{}", new Object[]{SM4ECBAndMACUtils.getStaticEcbEncryptUrl(), SM4ECBAndMACUtils.getStaticAuthorization(), SM4ECBAndMACUtils.getStaticXIcspTenantCode()});
                return null;
            }
            try {
                String code;
                httpClient = HttpClients.createDefault();
                post.setConfig(requestConfig);
                response = httpClient.execute((HttpUriRequest)post);
                entity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)entity);
                log.info("SM4ECB\u89e3\u5bc6\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String string = code = jsonObject.containsKey((Object)"code") ? jsonObject.getString("code") : "";
                if ("0".equals(code)) {
                    SM4ECBDecryptResponseDTO sm4ECBDecryptResponseDTO;
                    SM4ECBDecryptResponseDTO sM4ECBDecryptResponseDTO = sm4ECBDecryptResponseDTO = (SM4ECBDecryptResponseDTO)jsonObject.toJavaObject(SM4ECBDecryptResponseDTO.class);
                    return sM4ECBDecryptResponseDTO;
                }
                SM4ECBDecryptResponseDTO sM4ECBDecryptResponseDTO = null;
                return sM4ECBDecryptResponseDTO;
            }
            catch (Exception e) {
                AssertUtils.assertFalse((++retryCount >= maxRetries ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("SM4ECB\u89e3\u5bc6\u5931\u8d25\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a" + retryCount));
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (httpClient == null) continue;
                httpClient.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SM4MACEncryptResponseDTO sm4MACEncrypt(SM4MACEncryptRequestDTO dto) throws IOException {
        int retryCount = 0;
        String json = JSONObject.toJSONString((Object)dto);
        log.info("SM4MAC\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)json);
        while (retryCount < maxRetries) {
            CloseableHttpClient httpClient = null;
            CloseableHttpResponse response = null;
            HttpEntity entity = null;
            HttpPost post = new HttpPost(SM4ECBAndMACUtils.getStaticMacEncryptUrl());
            post.setHeader("Authorization", SM4ECBAndMACUtils.getStaticAuthorization());
            post.setHeader("X-ICSP-Tenant-Code", SM4ECBAndMACUtils.getStaticXIcspTenantCode());
            post.setHeader("Content-type", "application/json");
            StringEntity stringEntity = new StringEntity(json, "UTF-8");
            stringEntity.setContentType("application/json");
            post.setEntity((HttpEntity)stringEntity);
            if ("dacs".equals(SM4ECBAndMACUtils.getStaticProfileActive())) {
                log.info("url:{}, authorization:{}, x-icsp-tenant-code:{}", new Object[]{SM4ECBAndMACUtils.getStaticEcbEncryptUrl(), SM4ECBAndMACUtils.getStaticAuthorization(), SM4ECBAndMACUtils.getStaticXIcspTenantCode()});
                return null;
            }
            try {
                String code;
                httpClient = HttpClients.createDefault();
                post.setConfig(requestConfig);
                response = httpClient.execute((HttpUriRequest)post);
                entity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)entity);
                log.info("SM4MAC\u52a0\u5bc6\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String string = code = jsonObject.containsKey((Object)"code") ? jsonObject.getString("code") : "";
                if ("0".equals(code)) {
                    SM4MACEncryptResponseDTO sm4MACEncryptResponseDTO;
                    SM4MACEncryptResponseDTO sM4MACEncryptResponseDTO = sm4MACEncryptResponseDTO = (SM4MACEncryptResponseDTO)jsonObject.toJavaObject(SM4MACEncryptResponseDTO.class);
                    return sM4MACEncryptResponseDTO;
                }
                SM4MACEncryptResponseDTO sM4MACEncryptResponseDTO = null;
                return sM4MACEncryptResponseDTO;
            }
            catch (Exception e) {
                AssertUtils.assertFalse((++retryCount >= maxRetries ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("SM4MAC\u52a0\u5bc6\u5931\u8d25\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a" + retryCount));
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (httpClient == null) continue;
                httpClient.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SM4MACDecryptResponseDTO sm4MACDecrypt(SM4MACDecryptRequestDTO dto) throws IOException {
        int retryCount = 0;
        String json = JSONObject.toJSONString((Object)dto);
        log.info("SM4MAC\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)json);
        while (retryCount < maxRetries) {
            CloseableHttpClient httpClient = null;
            CloseableHttpResponse response = null;
            HttpEntity entity = null;
            HttpPost post = new HttpPost(SM4ECBAndMACUtils.getStaticMacDecryptUrl());
            post.setHeader("Authorization", SM4ECBAndMACUtils.getStaticAuthorization());
            post.setHeader("X-ICSP-Tenant-Code", SM4ECBAndMACUtils.getStaticXIcspTenantCode());
            post.setHeader("Content-type", "application/json");
            StringEntity stringEntity = new StringEntity(json, "UTF-8");
            stringEntity.setContentType("application/json");
            post.setEntity((HttpEntity)stringEntity);
            if ("dacs".equals(SM4ECBAndMACUtils.getStaticProfileActive())) {
                log.info("url:{}, authorization:{}, x-icsp-tenant-code:{}", new Object[]{SM4ECBAndMACUtils.getStaticEcbEncryptUrl(), SM4ECBAndMACUtils.getStaticAuthorization(), SM4ECBAndMACUtils.getStaticXIcspTenantCode()});
                return null;
            }
            try {
                String code;
                httpClient = HttpClients.createDefault();
                post.setConfig(requestConfig);
                response = httpClient.execute((HttpUriRequest)post);
                entity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)entity);
                log.info("SM4MAC\u9a8c\u8bc1\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String string = code = jsonObject.containsKey((Object)"code") ? jsonObject.getString("code") : "";
                if ("0".equals(code)) {
                    SM4MACDecryptResponseDTO sm4MACDecryptResponseDTO;
                    SM4MACDecryptResponseDTO sM4MACDecryptResponseDTO = sm4MACDecryptResponseDTO = (SM4MACDecryptResponseDTO)jsonObject.toJavaObject(SM4MACDecryptResponseDTO.class);
                    return sM4MACDecryptResponseDTO;
                }
                SM4MACDecryptResponseDTO sM4MACDecryptResponseDTO = null;
                return sM4MACDecryptResponseDTO;
            }
            catch (Exception e) {
                AssertUtils.assertFalse((++retryCount >= maxRetries ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("SM4MAC\u9a8c\u8bc1\u5931\u8d25\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a" + retryCount));
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (httpClient == null) continue;
                httpClient.close();
            }
        }
        return null;
    }

    static {
        maxRetries = 10;
        requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();
    }
}

