/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.common.utils;

import com.beiming.odr.peace.common.utils.HttpClientResult;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static final String ENCODING = "UTF-8";
    private static final int CONNECT_TIMEOUT = 6000;
    private static final int SOCKET_TIMEOUT = 6000;

    public static HttpClientResult doGet(String url) throws Exception {
        return HttpClientUtil.doGet(url, null, null);
    }

    public static HttpClientResult doGet(String url, Map<String, String> params) throws Exception {
        return HttpClientUtil.doGet(url, null, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClientResult doGet(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        URIBuilder uriBuilder = new URIBuilder(url);
        if (params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                uriBuilder.setParameter(entry.getKey(), entry.getValue());
            }
        }
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(6000).setSocketTimeout(6000).build();
        httpGet.setConfig(requestConfig);
        HttpClientUtil.packageHeader(headers, (HttpRequestBase)httpGet);
        CloseableHttpResponse httpResponse = null;
        try {
            HttpClientResult httpClientResult = HttpClientUtil.getHttpClientResult(httpResponse, httpClient, (HttpRequestBase)httpGet);
            return httpClientResult;
        }
        finally {
            HttpClientUtil.release(httpResponse, httpClient);
        }
    }

    public static HttpClientResult doPost(String url) throws Exception {
        return HttpClientUtil.doPost(url, null, null);
    }

    public static HttpClientResult doPost(String url, Map<String, String> params) throws Exception {
        return HttpClientUtil.doPost(url, null, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClientResult doPost(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(6000).setSocketTimeout(6000).build();
        httpPost.setConfig(requestConfig);
        HttpClientUtil.packageHeader(headers, (HttpRequestBase)httpPost);
        HttpClientUtil.packageParam(params, (HttpEntityEnclosingRequestBase)httpPost);
        CloseableHttpResponse httpResponse = null;
        try {
            HttpClientResult httpClientResult = HttpClientUtil.getHttpClientResult(httpResponse, httpClient, (HttpRequestBase)httpPost);
            return httpClientResult;
        }
        finally {
            HttpClientUtil.release(httpResponse, httpClient);
        }
    }

    public static HttpClientResult doPut(String url) throws Exception {
        return HttpClientUtil.doPut(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClientResult doPut(String url, Map<String, String> params) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPut httpPut = new HttpPut(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(6000).setSocketTimeout(6000).build();
        httpPut.setConfig(requestConfig);
        HttpClientUtil.packageParam(params, (HttpEntityEnclosingRequestBase)httpPut);
        CloseableHttpResponse httpResponse = null;
        try {
            HttpClientResult httpClientResult = HttpClientUtil.getHttpClientResult(httpResponse, httpClient, (HttpRequestBase)httpPut);
            return httpClientResult;
        }
        finally {
            HttpClientUtil.release(httpResponse, httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClientResult doDelete(String url) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpDelete httpDelete = new HttpDelete(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(6000).setSocketTimeout(6000).build();
        httpDelete.setConfig(requestConfig);
        CloseableHttpResponse httpResponse = null;
        try {
            HttpClientResult httpClientResult = HttpClientUtil.getHttpClientResult(httpResponse, httpClient, (HttpRequestBase)httpDelete);
            return httpClientResult;
        }
        finally {
            HttpClientUtil.release(httpResponse, httpClient);
        }
    }

    public static HttpClientResult doDelete(String url, Map<String, String> params) throws Exception {
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("_method", "delete");
        return HttpClientUtil.doPost(url, params);
    }

    public static void packageHeader(Map<String, String> params, HttpRequestBase httpMethod) {
        if (params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                httpMethod.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void packageParam(Map<String, String> params, HttpEntityEnclosingRequestBase httpMethod) throws UnsupportedEncodingException {
        if (params != null) {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, ENCODING));
        }
    }

    public static HttpClientResult getHttpClientResult(CloseableHttpResponse httpResponse, CloseableHttpClient httpClient, HttpRequestBase httpMethod) throws Exception {
        httpResponse = httpClient.execute((HttpUriRequest)httpMethod);
        if (httpResponse != null && httpResponse.getStatusLine() != null) {
            String content = "";
            if (httpResponse.getEntity() != null) {
                content = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)ENCODING);
            }
            return new HttpClientResult(httpResponse.getStatusLine().getStatusCode(), content);
        }
        return new HttpClientResult(500);
    }

    public static void release(CloseableHttpResponse httpResponse, CloseableHttpClient httpClient) throws IOException {
        if (httpResponse != null) {
            httpResponse.close();
        }
        if (httpClient != null) {
            httpClient.close();
        }
    }
}

