/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.common.utils.sm4;

import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.utils.sm4.SM4Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class CustomHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] requestBody;
    private Map<String, String> headerMap = new HashMap<String, String>();

    public CustomHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        if (null == this.requestBody) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)baos);
            this.requestBody = baos.toByteArray();
            System.out.println(this.requestBody);
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        String body = new String(this.requestBody);
        System.out.println(body);
        try {
            if (StringUtils.isNotEmpty((CharSequence)body)) {
                body = SM4Utils.decryptDataCbc(body);
            }
        }
        catch (Exception e) {
            System.out.println("=====Exception============" + e.getMessage());
            throw new RuntimeException(e);
        }
        final ByteArrayInputStream stream = new ByteArrayInputStream(StringUtils.isNotEmpty((CharSequence)body) ? body.getBytes(StandardCharsets.UTF_8) : "".getBytes(StandardCharsets.UTF_8));
        ServletInputStream inputStream = new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return stream.read();
            }
        };
        return inputStream;
    }

    public void addHeader(String name, String value) {
        this.headerMap.put(name, value);
    }

    public String getHeader(String name) {
        String headerValue = super.getHeader(name);
        if (this.headerMap.containsKey(name)) {
            headerValue = this.headerMap.get(name);
        }
        return headerValue;
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList names = Collections.list(super.getHeaderNames());
        for (String name : this.headerMap.keySet()) {
            names.add(name);
        }
        return Collections.enumeration(names);
    }

    public Enumeration<String> getHeaders(String name) {
        List<Object> values = Collections.list(super.getHeaders(name));
        if (this.headerMap.containsKey(name)) {
            values = Arrays.asList(this.headerMap.get(name));
        }
        return Collections.enumeration(values);
    }
}

