/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.common.utils.sm4.hainanrequestdto.SM4ECBDecrptyRequestDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanrequestdto.SM4ECBEncryptRequestDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanrequestdto.SM4MACDecryptRequestDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanrequestdto.SM4MACEncryptRequestDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanresponsedto.SM4ECBDecryptResponseDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanresponsedto.SM4ECBEncryptResponseDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanresponsedto.SM4MACDecryptResponseDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanresponsedto.SM4MACEncryptResponseDTO;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class SM4ECBAndMACUtils {
    private static final Logger log = LoggerFactory.getLogger(SM4ECBAndMACUtils.class);
    private static String xIcspTenantCode = "hndyzjrmfy_hllt";
    private static String authorization = "Basic aG5keXpqcm1meV9obGx0X3NzamZzd3l0cHQ6MXFhekBXU1g=";
    private static String ecbEncryptUrl = "https://10.146.19.6:15443/api/v1/cipher/json/encrypt";
    private static String ecbDecryptUrl = "https://10.146.19.6:15443/api/v1/cipher/json/decrypt";
    private static String macEncryptUrl = "https://10.146.19.6:15443/api/v1/cipher/mac";
    private static String macDecryptUrl = "https://10.146.19.6:15443/api/v1/cipher/macVerify";
    @Value(value="${spring.profiles.active}")
    private String profileActive;
    private static int maxRetries = 10;
    private static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SM4ECBEncryptResponseDTO sm4ECBEncrypt(SM4ECBEncryptRequestDTO dto) throws IOException {
        boolean retryCount = false;
        String json = JSONObject.toJSONString((Object)dto);
        log.info("SM4ECB\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)json);
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        HttpPost post = new HttpPost(ecbDecryptUrl);
        post.setHeader("Authorization", authorization);
        post.setHeader("X-ICSP-Tenant-Code", xIcspTenantCode);
        post.setHeader("Content-type", "application/json");
        post.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        try {
            String code;
            log.info("url:{}, authorization:{}, x-icsp-tenant-code:{}", new Object[]{ecbEncryptUrl, authorization, xIcspTenantCode});
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).build();
            post.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)post);
            entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            log.info("SM4ECB\u52a0\u5bc6\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            String string = code = jsonObject.containsKey((Object)"code") ? jsonObject.getString("code") : "";
            if ("0".equals(code)) {
                SM4ECBEncryptResponseDTO sm4ECBEncryptResponseDTO;
                SM4ECBEncryptResponseDTO sM4ECBEncryptResponseDTO = sm4ECBEncryptResponseDTO = (SM4ECBEncryptResponseDTO)jsonObject.toJavaObject(SM4ECBEncryptResponseDTO.class);
                return sM4ECBEncryptResponseDTO;
            }
            SM4ECBEncryptResponseDTO sM4ECBEncryptResponseDTO = null;
            return sM4ECBEncryptResponseDTO;
        }
        catch (Exception e) {
            log.info("error message {}", (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SM4ECBDecryptResponseDTO sm4ECBDecrypt(SM4ECBDecrptyRequestDTO dto) throws IOException {
        boolean retryCount = false;
        String json = JSONObject.toJSONString((Object)dto);
        log.info("SM4ECB\u89e3\u5bc6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)json);
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        HttpPost post = new HttpPost(ecbDecryptUrl);
        post.setHeader("Authorization", authorization);
        post.setHeader("X-ICSP-Tenant-Code", xIcspTenantCode);
        post.setHeader("Content-type", "application/json");
        post.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        try {
            String code;
            log.info("url:{}, authorization:{}, x-icsp-tenant-code:{}", new Object[]{ecbDecryptUrl, authorization, xIcspTenantCode});
            httpClient = HttpClients.createDefault();
            post.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)post);
            entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            log.info("SM4ECB\u89e3\u5bc6\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            String string = code = jsonObject.containsKey((Object)"code") ? jsonObject.getString("code") : "";
            if ("0".equals(code)) {
                SM4ECBDecryptResponseDTO sm4ECBDecryptResponseDTO;
                SM4ECBDecryptResponseDTO sM4ECBDecryptResponseDTO = sm4ECBDecryptResponseDTO = (SM4ECBDecryptResponseDTO)jsonObject.toJavaObject(SM4ECBDecryptResponseDTO.class);
                return sM4ECBDecryptResponseDTO;
            }
            SM4ECBDecryptResponseDTO sM4ECBDecryptResponseDTO = null;
            return sM4ECBDecryptResponseDTO;
        }
        catch (Exception e) {
            log.info("error msg {}", (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SM4MACEncryptResponseDTO sm4MACEncrypt(SM4MACEncryptRequestDTO dto) throws IOException {
        int retryCount = 0;
        String json = JSONObject.toJSONString((Object)dto);
        log.info("SM4MAC\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)json);
        while (retryCount < maxRetries) {
            CloseableHttpClient httpClient = null;
            CloseableHttpResponse response = null;
            HttpEntity entity = null;
            HttpPost post = new HttpPost(macEncryptUrl);
            post.setHeader("Authorization", authorization);
            post.setHeader("X-ICSP-Tenant-Code", xIcspTenantCode);
            post.setHeader("Content-type", "application/json");
            post.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            try {
                String code;
                log.info("url:{}, authorization:{}, x-icsp-tenant-code:{}", new Object[]{macEncryptUrl, authorization, xIcspTenantCode});
                httpClient = HttpClients.createDefault();
                post.setConfig(requestConfig);
                response = httpClient.execute((HttpUriRequest)post);
                entity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)entity);
                log.info("SM4MAC\u52a0\u5bc6\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String string = code = jsonObject.containsKey((Object)"code") ? jsonObject.getString("code") : "";
                if ("0".equals(code)) {
                    SM4MACEncryptResponseDTO sm4MACEncryptResponseDTO;
                    SM4MACEncryptResponseDTO sM4MACEncryptResponseDTO = sm4MACEncryptResponseDTO = (SM4MACEncryptResponseDTO)jsonObject.toJavaObject(SM4MACEncryptResponseDTO.class);
                    return sM4MACEncryptResponseDTO;
                }
                SM4MACEncryptResponseDTO sM4MACEncryptResponseDTO = null;
                return sM4MACEncryptResponseDTO;
            }
            catch (Exception e) {
                AssertUtils.assertFalse((++retryCount >= maxRetries ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("SM4MAC\u52a0\u5bc6\u5931\u8d25\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a" + retryCount));
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (httpClient == null) continue;
                httpClient.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SM4MACDecryptResponseDTO sm4MACDecrypt(SM4MACDecryptRequestDTO dto) throws IOException {
        int retryCount = 0;
        String json = JSONObject.toJSONString((Object)dto);
        log.info("SM4MAC\u9a8c\u8bc1\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)json);
        while (retryCount < maxRetries) {
            CloseableHttpClient httpClient = null;
            CloseableHttpResponse response = null;
            HttpEntity entity = null;
            HttpPost post = new HttpPost(macDecryptUrl);
            post.setHeader("Authorization", authorization);
            post.setHeader("X-ICSP-Tenant-Code", xIcspTenantCode);
            post.setHeader("Content-type", "application/json");
            post.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            try {
                String code;
                httpClient = HttpClients.createDefault();
                post.setConfig(requestConfig);
                response = httpClient.execute((HttpUriRequest)post);
                entity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)entity);
                log.info("SM4MAC\u9a8c\u8bc1\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String string = code = jsonObject.containsKey((Object)"code") ? jsonObject.getString("code") : "";
                if ("0".equals(code)) {
                    SM4MACDecryptResponseDTO sm4MACDecryptResponseDTO;
                    SM4MACDecryptResponseDTO sM4MACDecryptResponseDTO = sm4MACDecryptResponseDTO = (SM4MACDecryptResponseDTO)jsonObject.toJavaObject(SM4MACDecryptResponseDTO.class);
                    return sM4MACDecryptResponseDTO;
                }
                SM4MACDecryptResponseDTO sM4MACDecryptResponseDTO = null;
                return sM4MACDecryptResponseDTO;
            }
            catch (Exception e) {
                AssertUtils.assertFalse((++retryCount >= maxRetries ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("SM4MAC\u9a8c\u8bc1\u5931\u8d25\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a" + retryCount));
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (httpClient == null) continue;
                httpClient.close();
            }
        }
        return null;
    }
}

