/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.common.utils;

import com.alibaba.fastjson.util.IOUtils;
import com.beiming.odr.peace.common.utils.FileType;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImgTools {
    private static final Logger log = LoggerFactory.getLogger(ImgTools.class);
    public static final String IMAGE_SIZE = "SIZE";
    public static final String IMAGE_WIDTH = "IMAGE.WIDTH";
    public static final String IMAGE_HEIGHT = "IMAGE.HEIGHT";
    public static final String IMAGE_MAX_LINE = "IMAGE.MAX_LINE";

    public static byte[] compressUnderSize(byte[] srcImgData, long maxSize) {
        double scale = 0.9;
        byte[] imgData = Arrays.copyOf(srcImgData, srcImgData.length);
        if ((long)imgData.length > maxSize) {
            do {
                try {
                    imgData = ImgTools.compress(imgData, scale);
                }
                catch (IOException e) {
                    throw new IllegalStateException("\u538b\u7f29\u56fe\u7247\u8fc7\u7a0b\u4e2d\u51fa\u9519\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\u7ba1\u7406\u5458\uff01", e);
                }
            } while ((long)imgData.length > maxSize);
        }
        return imgData;
    }

    public static byte[] compress(byte[] srcImgData, double scale) throws IOException {
        BufferedImage bi = ImageIO.read(new ByteArrayInputStream(srcImgData));
        int width = (int)((double)bi.getWidth() * scale);
        int height = (int)((double)bi.getHeight() * scale);
        String fileType = FileType.getFileTypeByStream(srcImgData);
        log.info("fileType:{}", (Object)fileType);
        int imageType = ImgTools.getImageType(fileType);
        Image image = bi.getScaledInstance(width, height, 4);
        BufferedImage tag = new BufferedImage(width, height, imageType);
        Graphics g = tag.getGraphics();
        g.setColor(Color.RED);
        g.drawImage(image, 0, 0, null);
        g.dispose();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)tag, fileType, bOut);
        return bOut.toByteArray();
    }

    private static int getImageType(String fileType) {
        if ("png".equalsIgnoreCase(fileType)) {
            return 2;
        }
        return 1;
    }

    public static Map<String, Object> getImageInfo(String filePath) {
        File file = new File(filePath);
        return ImgTools.getImageInfo(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getImageInfo(File file) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> imageInfoMap = new HashMap<String, Object>();
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            BufferedImage image = ImageIO.read(is);
            imageInfoMap.put(IMAGE_WIDTH, image.getWidth());
            imageInfoMap.put(IMAGE_HEIGHT, image.getHeight());
            imageInfoMap.put(IMAGE_MAX_LINE, image.getWidth() > image.getHeight());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                IOUtils.close((Closeable)is);
            }
        }
        long endTime = System.currentTimeMillis();
        log.info("take time: " + (endTime - startTime));
        return imageInfoMap;
    }

    public static int zipImage(File srcFile, File destFile) throws Exception {
        double scale = 0.0;
        double scale100 = 100.0;
        byte[] srcImgData = FileUtils.readFileToByteArray((File)srcFile);
        Map<String, Object> imageInfo = ImgTools.getImageInfo(srcFile);
        boolean whichLineMax = MapUtils.getBooleanValue(imageInfo, (Object)IMAGE_MAX_LINE);
        scale = whichLineMax ? scale100 / MapUtils.getDoubleValue(imageInfo, (Object)IMAGE_HEIGHT) : scale100 / MapUtils.getDoubleValue(imageInfo, (Object)IMAGE_WIDTH);
        byte[] compress = ImgTools.compress(srcImgData, scale);
        FileUtils.writeByteArrayToFile((File)destFile, (byte[])compress);
        return compress.length;
    }
}

