/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.domain.dto.responsedto;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.util.Date2LongSerialize;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.constants.MeetingUserTypeConst;
import com.beiming.odr.peace.common.enums.ColumnEnums;
import com.beiming.odr.referee.dto.responsedto.CaseMemberResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseRoomInfoResDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.util.CollectionUtils;

@ApiModel(value="\u6211\u7684\u8c03\u89e3\u5ba4\u5217\u8868\u8fd4\u56de\u53c2\u6570")
public class MyMediationRoomPageListResponseDTO
implements Serializable {
    private static final long serialVersionUID = -6082071778303288081L;
    @ApiModelProperty(value="\u8c03\u89e3\u5ba4id")
    private String bizRoomId;
    @ApiModelProperty(value="\u623f\u95f4id")
    private String roomId;
    @ApiModelProperty(value="\u8c03\u89e3\u5ba4\u540d\u79f0")
    private String roomName;
    @ApiModelProperty(value="\u53c2\u4f1a\u4ebaid")
    private String joinUserId;
    @ApiModelProperty(value="\u53c2\u4f1a\u4eba\u540d\u79f0")
    private String joinUserName;
    @ApiModelProperty(value="\u53c2\u4e0e\u4eba\u6570")
    private Integer joinUserNumber;
    @ApiModelProperty(value="\u5f53\u4e8b\u4eba")
    private String litigant;
    @ApiModelProperty(value="\u6cd5\u9662\u4eba\u5458")
    private String staff;
    @ApiModelProperty(value="\u8c03\u89e3\u5ba4\u72b6\u6001(\u521d\u59cb\u5316 INIT,\u8fdb\u884c\u4e2d RUNNING,\u5df2\u7ed3\u675f END)")
    private String roomStatus;
    @ApiModelProperty(value="\u6700\u540e\u6d88\u606f")
    private String lastMessage;
    @ApiModelProperty(value="\u672a\u8bfb\u6d88\u606f\u6570")
    private Integer unreadMessageCount;
    @ApiModelProperty(value="\u6700\u540e\u6d88\u606f\u65f6\u95f4")
    @JsonSerialize(using=Date2LongSerialize.class)
    private Date lastMessageTime;
    @ApiModelProperty(value="\u65f6\u95f4")
    private String holdCourtTime;
    @ApiModelProperty(value="\u6848\u4ef6\u6765\u6e90")
    private String creatorType;
    @ApiModelProperty(value="\u53d1\u8d77\u5165\u53e3")
    private String initiatingEntrance;
    @ApiModelProperty(value="\u5f00\u5ead\u6cd5\u5ead")
    private String holdCourt;
    @ApiModelProperty(value="\u5f00\u5ead\u6b21\u6570")
    private String holdCourtNum;
    @ApiModelProperty(value="\u5f00\u5ead\u65f6\u95f4")
    @JsonSerialize(using=Date2LongSerialize.class)
    private Date orderTime;
    private Object isMine;
    @ApiModelProperty(value="\u6848\u7531")
    private String causeName;
    private Object canItEnd;
    private String caseType;
    private String caseName;
    private String procedure;
    private String undertakeDepartment;
    private String undertakeUser;
    private String undertakeUserPhone;
    private String superviseType;
    private String superviseUser;
    private String superviseUserPhone;
    private Date startTime;
    private Date endTime;
    private String unitName;
    private String creditCode;
    private boolean isReadNotification = false;

    public MyMediationRoomPageListResponseDTO() {
    }

    public MyMediationRoomPageListResponseDTO(CaseRoomInfoResDTO roomInfo) {
        this.bizRoomId = roomInfo.getBizRoomId();
        this.roomId = roomInfo.getRoomId();
        this.roomName = roomInfo.getRoomName();
        this.roomStatus = roomInfo.getRoomStatus();
        this.lastMessage = roomInfo.getLastMessage();
        this.unreadMessageCount = roomInfo.getUnreadMessageCount();
        this.lastMessageTime = roomInfo.getLastMessageTime();
        this.creatorType = roomInfo.getCreatorType();
        this.orderTime = roomInfo.getOrderTime();
        this.causeName = roomInfo.getCauseName();
        this.isMine = roomInfo.getIsMine();
        this.canItEnd = roomInfo.getCanItEnd();
        this.startTime = roomInfo.getStartTime();
        this.endTime = roomInfo.getEndTime();
        this.isReadNotification = roomInfo.isReadNotification();
        if (roomInfo.getExpandAttribute() != null) {
            String extInfo = roomInfo.getExpandAttribute();
            JSONObject json = JSONObject.parseObject((String)extInfo);
            this.caseType = json.getString(ColumnEnums.CASE_TYPE.desc());
            this.caseName = json.getString(ColumnEnums.CASE_NAME.desc());
            this.procedure = json.getString(ColumnEnums.PROCEDURE.desc());
            this.undertakeDepartment = json.getString(ColumnEnums.UNDERTAKE_DEPARTMENT.desc());
            this.superviseType = json.getString(ColumnEnums.SUPERVISE_TYPE.desc());
            this.superviseUser = json.getString(ColumnEnums.SUPERVISE_USER.desc());
            this.superviseUserPhone = json.getString(ColumnEnums.SUPERVISE_USER_PHONE.desc());
            this.undertakeUser = json.getString(ColumnEnums.UNDERTAKE_USER.desc());
            this.undertakeUserPhone = json.getString(ColumnEnums.UNDERTAKE_USER_PHONE.desc());
        }
        List members = roomInfo.getMembers();
        ArrayList<String> userIdList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)members)) {
            for (CaseMemberResDTO member : members) {
                if (userIdList.contains(member.getMemberId())) continue;
                String type = member.getMemberType();
                JSONObject json = new JSONObject();
                String unitNames = null;
                if (member.getExpandAttribute() != null) {
                    json = JSONObject.parseObject((String)member.getExpandAttribute());
                    this.unitName = json.getString(ColumnEnums.UNIT_NAME.desc());
                    this.creditCode = json.getString(ColumnEnums.CREDIT_CODE.desc());
                    unitNames = json.getString(ColumnEnums.UNIT_NAME.desc());
                }
                if (unitNames != null && StringUtils.isNotEmpty(unitNames)) {
                    member.setMemberName(unitNames + "(" + MeetingUserTypeConst.getUserIdentity((String)this.getType(type, json)) + ")");
                } else {
                    member.setMemberName(member.getMemberName() + "(" + MeetingUserTypeConst.getUserIdentity((String)this.getType(type, json)) + ")");
                }
                if (member.getMemberType().equals("MEDIATOR") || member.getMemberType().equals("ASSISTANT_JUDGE") || member.getMemberType().equals("CLERK") || member.getMemberType().equals("JUROR")) {
                    this.staff = StringUtils.isBlank((String)this.staff) ? member.getMemberName() : this.staff + "," + member.getMemberName();
                } else {
                    this.litigant = StringUtils.isBlank((String)this.litigant) ? member.getMemberName() : this.litigant + "," + member.getMemberName();
                }
                this.joinUserId = StringUtils.isBlank((String)this.joinUserId) ? member.getMemberId() : this.joinUserId + "," + member.getMemberId();
                this.joinUserName = StringUtils.isBlank((String)this.joinUserName) ? member.getMemberName() : this.joinUserName + "," + member.getMemberName();
                userIdList.add(member.getMemberId());
            }
            this.joinUserNumber = userIdList.size();
        }
    }

    public String getType(String type, JSONObject json) {
        if (json.get((Object)ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc()) != null && "APPLICANT".equals(type)) {
            type = "SECOND_APPLICANT";
        }
        if (json.get((Object)ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc()) != null && "RESPONDENT".equals(type)) {
            type = "SECOND_RESPONDENT";
        }
        return type;
    }

    public String getBizRoomId() {
        return this.bizRoomId;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public String getRoomName() {
        return this.roomName;
    }

    public String getJoinUserId() {
        return this.joinUserId;
    }

    public String getJoinUserName() {
        return this.joinUserName;
    }

    public Integer getJoinUserNumber() {
        return this.joinUserNumber;
    }

    public String getLitigant() {
        return this.litigant;
    }

    public String getStaff() {
        return this.staff;
    }

    public String getRoomStatus() {
        return this.roomStatus;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public Integer getUnreadMessageCount() {
        return this.unreadMessageCount;
    }

    public Date getLastMessageTime() {
        return this.lastMessageTime;
    }

    public String getHoldCourtTime() {
        return this.holdCourtTime;
    }

    public String getCreatorType() {
        return this.creatorType;
    }

    public String getInitiatingEntrance() {
        return this.initiatingEntrance;
    }

    public String getHoldCourt() {
        return this.holdCourt;
    }

    public String getHoldCourtNum() {
        return this.holdCourtNum;
    }

    public Date getOrderTime() {
        return this.orderTime;
    }

    public Object getIsMine() {
        return this.isMine;
    }

    public String getCauseName() {
        return this.causeName;
    }

    public Object getCanItEnd() {
        return this.canItEnd;
    }

    public String getCaseType() {
        return this.caseType;
    }

    public String getCaseName() {
        return this.caseName;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public String getUndertakeDepartment() {
        return this.undertakeDepartment;
    }

    public String getUndertakeUser() {
        return this.undertakeUser;
    }

    public String getUndertakeUserPhone() {
        return this.undertakeUserPhone;
    }

    public String getSuperviseType() {
        return this.superviseType;
    }

    public String getSuperviseUser() {
        return this.superviseUser;
    }

    public String getSuperviseUserPhone() {
        return this.superviseUserPhone;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getCreditCode() {
        return this.creditCode;
    }

    public boolean isReadNotification() {
        return this.isReadNotification;
    }

    public void setBizRoomId(String bizRoomId) {
        this.bizRoomId = bizRoomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    public void setJoinUserId(String joinUserId) {
        this.joinUserId = joinUserId;
    }

    public void setJoinUserName(String joinUserName) {
        this.joinUserName = joinUserName;
    }

    public void setJoinUserNumber(Integer joinUserNumber) {
        this.joinUserNumber = joinUserNumber;
    }

    public void setLitigant(String litigant) {
        this.litigant = litigant;
    }

    public void setStaff(String staff) {
        this.staff = staff;
    }

    public void setRoomStatus(String roomStatus) {
        this.roomStatus = roomStatus;
    }

    public void setLastMessage(String lastMessage) {
        this.lastMessage = lastMessage;
    }

    public void setUnreadMessageCount(Integer unreadMessageCount) {
        this.unreadMessageCount = unreadMessageCount;
    }

    public void setLastMessageTime(Date lastMessageTime) {
        this.lastMessageTime = lastMessageTime;
    }

    public void setHoldCourtTime(String holdCourtTime) {
        this.holdCourtTime = holdCourtTime;
    }

    public void setCreatorType(String creatorType) {
        this.creatorType = creatorType;
    }

    public void setInitiatingEntrance(String initiatingEntrance) {
        this.initiatingEntrance = initiatingEntrance;
    }

    public void setHoldCourt(String holdCourt) {
        this.holdCourt = holdCourt;
    }

    public void setHoldCourtNum(String holdCourtNum) {
        this.holdCourtNum = holdCourtNum;
    }

    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    public void setIsMine(Object isMine) {
        this.isMine = isMine;
    }

    public void setCauseName(String causeName) {
        this.causeName = causeName;
    }

    public void setCanItEnd(Object canItEnd) {
        this.canItEnd = canItEnd;
    }

    public void setCaseType(String caseType) {
        this.caseType = caseType;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }

    public void setUndertakeDepartment(String undertakeDepartment) {
        this.undertakeDepartment = undertakeDepartment;
    }

    public void setUndertakeUser(String undertakeUser) {
        this.undertakeUser = undertakeUser;
    }

    public void setUndertakeUserPhone(String undertakeUserPhone) {
        this.undertakeUserPhone = undertakeUserPhone;
    }

    public void setSuperviseType(String superviseType) {
        this.superviseType = superviseType;
    }

    public void setSuperviseUser(String superviseUser) {
        this.superviseUser = superviseUser;
    }

    public void setSuperviseUserPhone(String superviseUserPhone) {
        this.superviseUserPhone = superviseUserPhone;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public void setCreditCode(String creditCode) {
        this.creditCode = creditCode;
    }

    public void setReadNotification(boolean isReadNotification) {
        this.isReadNotification = isReadNotification;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MyMediationRoomPageListResponseDTO)) {
            return false;
        }
        MyMediationRoomPageListResponseDTO other = (MyMediationRoomPageListResponseDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$bizRoomId = this.getBizRoomId();
        String other$bizRoomId = other.getBizRoomId();
        if (this$bizRoomId == null ? other$bizRoomId != null : !this$bizRoomId.equals(other$bizRoomId)) {
            return false;
        }
        String this$roomId = this.getRoomId();
        String other$roomId = other.getRoomId();
        if (this$roomId == null ? other$roomId != null : !this$roomId.equals(other$roomId)) {
            return false;
        }
        String this$roomName = this.getRoomName();
        String other$roomName = other.getRoomName();
        if (this$roomName == null ? other$roomName != null : !this$roomName.equals(other$roomName)) {
            return false;
        }
        String this$joinUserId = this.getJoinUserId();
        String other$joinUserId = other.getJoinUserId();
        if (this$joinUserId == null ? other$joinUserId != null : !this$joinUserId.equals(other$joinUserId)) {
            return false;
        }
        String this$joinUserName = this.getJoinUserName();
        String other$joinUserName = other.getJoinUserName();
        if (this$joinUserName == null ? other$joinUserName != null : !this$joinUserName.equals(other$joinUserName)) {
            return false;
        }
        Integer this$joinUserNumber = this.getJoinUserNumber();
        Integer other$joinUserNumber = other.getJoinUserNumber();
        if (this$joinUserNumber == null ? other$joinUserNumber != null : !((Object)this$joinUserNumber).equals(other$joinUserNumber)) {
            return false;
        }
        String this$litigant = this.getLitigant();
        String other$litigant = other.getLitigant();
        if (this$litigant == null ? other$litigant != null : !this$litigant.equals(other$litigant)) {
            return false;
        }
        String this$staff = this.getStaff();
        String other$staff = other.getStaff();
        if (this$staff == null ? other$staff != null : !this$staff.equals(other$staff)) {
            return false;
        }
        String this$roomStatus = this.getRoomStatus();
        String other$roomStatus = other.getRoomStatus();
        if (this$roomStatus == null ? other$roomStatus != null : !this$roomStatus.equals(other$roomStatus)) {
            return false;
        }
        String this$lastMessage = this.getLastMessage();
        String other$lastMessage = other.getLastMessage();
        if (this$lastMessage == null ? other$lastMessage != null : !this$lastMessage.equals(other$lastMessage)) {
            return false;
        }
        Integer this$unreadMessageCount = this.getUnreadMessageCount();
        Integer other$unreadMessageCount = other.getUnreadMessageCount();
        if (this$unreadMessageCount == null ? other$unreadMessageCount != null : !((Object)this$unreadMessageCount).equals(other$unreadMessageCount)) {
            return false;
        }
        Date this$lastMessageTime = this.getLastMessageTime();
        Date other$lastMessageTime = other.getLastMessageTime();
        if (this$lastMessageTime == null ? other$lastMessageTime != null : !((Object)this$lastMessageTime).equals(other$lastMessageTime)) {
            return false;
        }
        String this$holdCourtTime = this.getHoldCourtTime();
        String other$holdCourtTime = other.getHoldCourtTime();
        if (this$holdCourtTime == null ? other$holdCourtTime != null : !this$holdCourtTime.equals(other$holdCourtTime)) {
            return false;
        }
        String this$creatorType = this.getCreatorType();
        String other$creatorType = other.getCreatorType();
        if (this$creatorType == null ? other$creatorType != null : !this$creatorType.equals(other$creatorType)) {
            return false;
        }
        String this$initiatingEntrance = this.getInitiatingEntrance();
        String other$initiatingEntrance = other.getInitiatingEntrance();
        if (this$initiatingEntrance == null ? other$initiatingEntrance != null : !this$initiatingEntrance.equals(other$initiatingEntrance)) {
            return false;
        }
        String this$holdCourt = this.getHoldCourt();
        String other$holdCourt = other.getHoldCourt();
        if (this$holdCourt == null ? other$holdCourt != null : !this$holdCourt.equals(other$holdCourt)) {
            return false;
        }
        String this$holdCourtNum = this.getHoldCourtNum();
        String other$holdCourtNum = other.getHoldCourtNum();
        if (this$holdCourtNum == null ? other$holdCourtNum != null : !this$holdCourtNum.equals(other$holdCourtNum)) {
            return false;
        }
        Date this$orderTime = this.getOrderTime();
        Date other$orderTime = other.getOrderTime();
        if (this$orderTime == null ? other$orderTime != null : !((Object)this$orderTime).equals(other$orderTime)) {
            return false;
        }
        Object this$isMine = this.getIsMine();
        Object other$isMine = other.getIsMine();
        if (this$isMine == null ? other$isMine != null : !this$isMine.equals(other$isMine)) {
            return false;
        }
        String this$causeName = this.getCauseName();
        String other$causeName = other.getCauseName();
        if (this$causeName == null ? other$causeName != null : !this$causeName.equals(other$causeName)) {
            return false;
        }
        Object this$canItEnd = this.getCanItEnd();
        Object other$canItEnd = other.getCanItEnd();
        if (this$canItEnd == null ? other$canItEnd != null : !this$canItEnd.equals(other$canItEnd)) {
            return false;
        }
        String this$caseType = this.getCaseType();
        String other$caseType = other.getCaseType();
        if (this$caseType == null ? other$caseType != null : !this$caseType.equals(other$caseType)) {
            return false;
        }
        String this$caseName = this.getCaseName();
        String other$caseName = other.getCaseName();
        if (this$caseName == null ? other$caseName != null : !this$caseName.equals(other$caseName)) {
            return false;
        }
        String this$procedure = this.getProcedure();
        String other$procedure = other.getProcedure();
        if (this$procedure == null ? other$procedure != null : !this$procedure.equals(other$procedure)) {
            return false;
        }
        String this$undertakeDepartment = this.getUndertakeDepartment();
        String other$undertakeDepartment = other.getUndertakeDepartment();
        if (this$undertakeDepartment == null ? other$undertakeDepartment != null : !this$undertakeDepartment.equals(other$undertakeDepartment)) {
            return false;
        }
        String this$undertakeUser = this.getUndertakeUser();
        String other$undertakeUser = other.getUndertakeUser();
        if (this$undertakeUser == null ? other$undertakeUser != null : !this$undertakeUser.equals(other$undertakeUser)) {
            return false;
        }
        String this$undertakeUserPhone = this.getUndertakeUserPhone();
        String other$undertakeUserPhone = other.getUndertakeUserPhone();
        if (this$undertakeUserPhone == null ? other$undertakeUserPhone != null : !this$undertakeUserPhone.equals(other$undertakeUserPhone)) {
            return false;
        }
        String this$superviseType = this.getSuperviseType();
        String other$superviseType = other.getSuperviseType();
        if (this$superviseType == null ? other$superviseType != null : !this$superviseType.equals(other$superviseType)) {
            return false;
        }
        String this$superviseUser = this.getSuperviseUser();
        String other$superviseUser = other.getSuperviseUser();
        if (this$superviseUser == null ? other$superviseUser != null : !this$superviseUser.equals(other$superviseUser)) {
            return false;
        }
        String this$superviseUserPhone = this.getSuperviseUserPhone();
        String other$superviseUserPhone = other.getSuperviseUserPhone();
        if (this$superviseUserPhone == null ? other$superviseUserPhone != null : !this$superviseUserPhone.equals(other$superviseUserPhone)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$unitName = this.getUnitName();
        String other$unitName = other.getUnitName();
        if (this$unitName == null ? other$unitName != null : !this$unitName.equals(other$unitName)) {
            return false;
        }
        String this$creditCode = this.getCreditCode();
        String other$creditCode = other.getCreditCode();
        if (this$creditCode == null ? other$creditCode != null : !this$creditCode.equals(other$creditCode)) {
            return false;
        }
        return this.isReadNotification() == other.isReadNotification();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MyMediationRoomPageListResponseDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bizRoomId = this.getBizRoomId();
        result = result * 59 + ($bizRoomId == null ? 43 : $bizRoomId.hashCode());
        String $roomId = this.getRoomId();
        result = result * 59 + ($roomId == null ? 43 : $roomId.hashCode());
        String $roomName = this.getRoomName();
        result = result * 59 + ($roomName == null ? 43 : $roomName.hashCode());
        String $joinUserId = this.getJoinUserId();
        result = result * 59 + ($joinUserId == null ? 43 : $joinUserId.hashCode());
        String $joinUserName = this.getJoinUserName();
        result = result * 59 + ($joinUserName == null ? 43 : $joinUserName.hashCode());
        Integer $joinUserNumber = this.getJoinUserNumber();
        result = result * 59 + ($joinUserNumber == null ? 43 : ((Object)$joinUserNumber).hashCode());
        String $litigant = this.getLitigant();
        result = result * 59 + ($litigant == null ? 43 : $litigant.hashCode());
        String $staff = this.getStaff();
        result = result * 59 + ($staff == null ? 43 : $staff.hashCode());
        String $roomStatus = this.getRoomStatus();
        result = result * 59 + ($roomStatus == null ? 43 : $roomStatus.hashCode());
        String $lastMessage = this.getLastMessage();
        result = result * 59 + ($lastMessage == null ? 43 : $lastMessage.hashCode());
        Integer $unreadMessageCount = this.getUnreadMessageCount();
        result = result * 59 + ($unreadMessageCount == null ? 43 : ((Object)$unreadMessageCount).hashCode());
        Date $lastMessageTime = this.getLastMessageTime();
        result = result * 59 + ($lastMessageTime == null ? 43 : ((Object)$lastMessageTime).hashCode());
        String $holdCourtTime = this.getHoldCourtTime();
        result = result * 59 + ($holdCourtTime == null ? 43 : $holdCourtTime.hashCode());
        String $creatorType = this.getCreatorType();
        result = result * 59 + ($creatorType == null ? 43 : $creatorType.hashCode());
        String $initiatingEntrance = this.getInitiatingEntrance();
        result = result * 59 + ($initiatingEntrance == null ? 43 : $initiatingEntrance.hashCode());
        String $holdCourt = this.getHoldCourt();
        result = result * 59 + ($holdCourt == null ? 43 : $holdCourt.hashCode());
        String $holdCourtNum = this.getHoldCourtNum();
        result = result * 59 + ($holdCourtNum == null ? 43 : $holdCourtNum.hashCode());
        Date $orderTime = this.getOrderTime();
        result = result * 59 + ($orderTime == null ? 43 : ((Object)$orderTime).hashCode());
        Object $isMine = this.getIsMine();
        result = result * 59 + ($isMine == null ? 43 : $isMine.hashCode());
        String $causeName = this.getCauseName();
        result = result * 59 + ($causeName == null ? 43 : $causeName.hashCode());
        Object $canItEnd = this.getCanItEnd();
        result = result * 59 + ($canItEnd == null ? 43 : $canItEnd.hashCode());
        String $caseType = this.getCaseType();
        result = result * 59 + ($caseType == null ? 43 : $caseType.hashCode());
        String $caseName = this.getCaseName();
        result = result * 59 + ($caseName == null ? 43 : $caseName.hashCode());
        String $procedure = this.getProcedure();
        result = result * 59 + ($procedure == null ? 43 : $procedure.hashCode());
        String $undertakeDepartment = this.getUndertakeDepartment();
        result = result * 59 + ($undertakeDepartment == null ? 43 : $undertakeDepartment.hashCode());
        String $undertakeUser = this.getUndertakeUser();
        result = result * 59 + ($undertakeUser == null ? 43 : $undertakeUser.hashCode());
        String $undertakeUserPhone = this.getUndertakeUserPhone();
        result = result * 59 + ($undertakeUserPhone == null ? 43 : $undertakeUserPhone.hashCode());
        String $superviseType = this.getSuperviseType();
        result = result * 59 + ($superviseType == null ? 43 : $superviseType.hashCode());
        String $superviseUser = this.getSuperviseUser();
        result = result * 59 + ($superviseUser == null ? 43 : $superviseUser.hashCode());
        String $superviseUserPhone = this.getSuperviseUserPhone();
        result = result * 59 + ($superviseUserPhone == null ? 43 : $superviseUserPhone.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $unitName = this.getUnitName();
        result = result * 59 + ($unitName == null ? 43 : $unitName.hashCode());
        String $creditCode = this.getCreditCode();
        result = result * 59 + ($creditCode == null ? 43 : $creditCode.hashCode());
        result = result * 59 + (this.isReadNotification() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "MyMediationRoomPageListResponseDTO(bizRoomId=" + this.getBizRoomId() + ", roomId=" + this.getRoomId() + ", roomName=" + this.getRoomName() + ", joinUserId=" + this.getJoinUserId() + ", joinUserName=" + this.getJoinUserName() + ", joinUserNumber=" + this.getJoinUserNumber() + ", litigant=" + this.getLitigant() + ", staff=" + this.getStaff() + ", roomStatus=" + this.getRoomStatus() + ", lastMessage=" + this.getLastMessage() + ", unreadMessageCount=" + this.getUnreadMessageCount() + ", lastMessageTime=" + this.getLastMessageTime() + ", holdCourtTime=" + this.getHoldCourtTime() + ", creatorType=" + this.getCreatorType() + ", initiatingEntrance=" + this.getInitiatingEntrance() + ", holdCourt=" + this.getHoldCourt() + ", holdCourtNum=" + this.getHoldCourtNum() + ", orderTime=" + this.getOrderTime() + ", isMine=" + this.getIsMine() + ", causeName=" + this.getCauseName() + ", canItEnd=" + this.getCanItEnd() + ", caseType=" + this.getCaseType() + ", caseName=" + this.getCaseName() + ", procedure=" + this.getProcedure() + ", undertakeDepartment=" + this.getUndertakeDepartment() + ", undertakeUser=" + this.getUndertakeUser() + ", undertakeUserPhone=" + this.getUndertakeUserPhone() + ", superviseType=" + this.getSuperviseType() + ", superviseUser=" + this.getSuperviseUser() + ", superviseUserPhone=" + this.getSuperviseUserPhone() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", unitName=" + this.getUnitName() + ", creditCode=" + this.getCreditCode() + ", isReadNotification=" + this.isReadNotification() + ")";
    }
}

