/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.domain.dto.responsedto;

import com.alibaba.fastjson.JSONObject;
import com.beiming.odr.peace.common.enums.ColumnEnums;
import com.beiming.odr.peace.domain.dto.responsedto.SchedulingInfoResponseDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingRoomInfoResDTO;
import com.beiming.odr.trial.api.dto.response.CaseInfoResponseDTO;
import com.beiming.odr.trial.api.dto.response.CaseOrderResponseDTO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ApiModel(description="\u83b7\u53d6\u6848\u4ef6\u4fe1\u606f\u51fa\u53c2")
public class GetCaseInfoResponseDTO
implements Serializable {
    private static final long serialVersionUID = -676010202004593699L;
    private Long id;
    @ApiModelProperty(value="\u5220\u9664\u72b6\u6001\uff1atrue\u4e3a\u5220\u9664")
    private Boolean deleteStatus;
    @ApiModelProperty(value="\u6848\u53f7")
    private String caseNumber;
    @ApiModelProperty(value="\u6848\u7531")
    private String caseCause;
    private String causeCode;
    @ApiModelProperty(value="\u7ecf\u529e\u6cd5\u9662")
    private String courtName;
    @ApiModelProperty(value="\u5f00\u5ead\u65f6\u95f4")
    private String holdCourt;
    @ApiModelProperty(value="\u6848\u4ef6\u6700\u540e\u4e00\u671f\u6392\u671f\u65f6\u95f4")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date lastOrderTime;
    @ApiModelProperty(value="\u6848\u4ef6\u9884\u7ea6\u7ed3\u675f\u65f6\u95f4")
    private String orderEndTime;
    @ApiModelProperty(value="\u6848\u4ef6\u6700\u540e\u4e00\u671f\u6392\u671f\u5ead\u5ba1\u72b6\u6001")
    private String lastMediationStatus;
    @ApiModelProperty(value="\u6cd5\u5ead\u540d\u79f0")
    private String courtRoomName;
    private String caseType;
    private String caseName;
    private String thirdCaseId;
    private String procedure;
    private String undertakeDepartment;
    private String undertakeUser;
    private String undertakeUserPhone;
    private String superviseType;
    private String superviseUser;
    private String superviseUserPhone;
    private Integer authFlag;
    private Integer callFlag;
    private String creatorType;
    @ApiModelProperty(value="\u6392\u671f\u4fe1\u606f")
    private List<SchedulingInfoResponseDTO> schedulingInfo;

    public static List<SchedulingInfoResponseDTO> toGetCaseOrders(CaseInfoResponseDTO dto) {
        if (!CollectionUtils.isEmpty((Collection)dto.getCaseOrder())) {
            ArrayList<SchedulingInfoResponseDTO> caseOrders = new ArrayList<SchedulingInfoResponseDTO>();
            SchedulingInfoResponseDTO schedulingInfo = null;
            for (CaseOrderResponseDTO caseOrder : dto.getCaseOrder()) {
                schedulingInfo = new SchedulingInfoResponseDTO();
                schedulingInfo.setHoldCourt(caseOrder.getDd());
                schedulingInfo.setHoldCourtNum(caseOrder.getTc());
                String holdCourtTime = "";
                if (caseOrder.getKtrq() != null && caseOrder.getKtsj() != null) {
                    holdCourtTime = caseOrder.getKtrq() + " " + caseOrder.getKtsj();
                }
                if (caseOrder.getJssj() != null && !"".equals(holdCourtTime)) {
                    holdCourtTime = holdCourtTime + "\u2014\u2014" + caseOrder.getJssj();
                }
                schedulingInfo.setHoldCourtTime(holdCourtTime);
                String realHoldCourtTime = "";
                if (caseOrder.getSjktrq() != null && caseOrder.getSjkssj() != null) {
                    realHoldCourtTime = caseOrder.getSjktrq() + " " + caseOrder.getSjkssj();
                }
                if (caseOrder.getSjjssj() != null && !"".equals(realHoldCourtTime)) {
                    realHoldCourtTime = realHoldCourtTime + "\u2014\u2014" + caseOrder.getSjjssj();
                }
                schedulingInfo.setRealHoldCourtTime(realHoldCourtTime);
                caseOrders.add(schedulingInfo);
            }
            return caseOrders;
        }
        return null;
    }

    public GetCaseInfoResponseDTO() {
    }

    public GetCaseInfoResponseDTO(CaseMeetingRoomInfoResDTO meetingInfo) {
        this.id = meetingInfo.getId();
        this.deleteStatus = meetingInfo.getStatus();
        this.caseNumber = meetingInfo.getName();
        this.caseCause = meetingInfo.getCauseName();
        this.causeCode = meetingInfo.getCauseCode();
        this.courtName = meetingInfo.getOrgName();
        this.thirdCaseId = meetingInfo.getThirdCaseId();
        this.authFlag = meetingInfo.getAuthFlag();
        this.callFlag = meetingInfo.getCallFlag();
        if (meetingInfo.getExpandAttribute() != null) {
            String extInfo = meetingInfo.getExpandAttribute();
            JSONObject json = JSONObject.parseObject((String)extInfo);
            this.caseType = json.getString(ColumnEnums.CASE_TYPE.desc());
            this.caseName = json.getString(ColumnEnums.CASE_NAME.desc());
            this.procedure = json.getString(ColumnEnums.PROCEDURE.desc());
            this.undertakeDepartment = json.getString(ColumnEnums.UNDERTAKE_DEPARTMENT.desc());
            this.undertakeUser = json.getString(ColumnEnums.UNDERTAKE_USER.desc());
            this.undertakeUserPhone = json.getString(ColumnEnums.UNDERTAKE_USER_PHONE.desc());
            this.superviseType = json.getString(ColumnEnums.SUPERVISE_TYPE.desc());
            this.superviseUser = json.getString(ColumnEnums.SUPERVISE_USER.desc());
            this.superviseUserPhone = json.getString(ColumnEnums.SUPERVISE_USER_PHONE.desc());
            String orderTime = meetingInfo.getOrderTime();
            String orderEndMinuteTime = json.getString(ColumnEnums.ORDER_END_TIME.desc());
            if (!StringUtils.isEmpty((Object)orderEndMinuteTime)) {
                this.orderEndTime = orderTime.substring(0, 10) + " " + orderEndMinuteTime;
            }
        }
        this.creatorType = meetingInfo.getCreatorType();
    }

    public Long getId() {
        return this.id;
    }

    public Boolean getDeleteStatus() {
        return this.deleteStatus;
    }

    public String getCaseNumber() {
        return this.caseNumber;
    }

    public String getCaseCause() {
        return this.caseCause;
    }

    public String getCauseCode() {
        return this.causeCode;
    }

    public String getCourtName() {
        return this.courtName;
    }

    public String getHoldCourt() {
        return this.holdCourt;
    }

    public Date getLastOrderTime() {
        return this.lastOrderTime;
    }

    public String getOrderEndTime() {
        return this.orderEndTime;
    }

    public String getLastMediationStatus() {
        return this.lastMediationStatus;
    }

    public String getCourtRoomName() {
        return this.courtRoomName;
    }

    public String getCaseType() {
        return this.caseType;
    }

    public String getCaseName() {
        return this.caseName;
    }

    public String getThirdCaseId() {
        return this.thirdCaseId;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public String getUndertakeDepartment() {
        return this.undertakeDepartment;
    }

    public String getUndertakeUser() {
        return this.undertakeUser;
    }

    public String getUndertakeUserPhone() {
        return this.undertakeUserPhone;
    }

    public String getSuperviseType() {
        return this.superviseType;
    }

    public String getSuperviseUser() {
        return this.superviseUser;
    }

    public String getSuperviseUserPhone() {
        return this.superviseUserPhone;
    }

    public Integer getAuthFlag() {
        return this.authFlag;
    }

    public Integer getCallFlag() {
        return this.callFlag;
    }

    public String getCreatorType() {
        return this.creatorType;
    }

    public List<SchedulingInfoResponseDTO> getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDeleteStatus(Boolean deleteStatus) {
        this.deleteStatus = deleteStatus;
    }

    public void setCaseNumber(String caseNumber) {
        this.caseNumber = caseNumber;
    }

    public void setCaseCause(String caseCause) {
        this.caseCause = caseCause;
    }

    public void setCauseCode(String causeCode) {
        this.causeCode = causeCode;
    }

    public void setCourtName(String courtName) {
        this.courtName = courtName;
    }

    public void setHoldCourt(String holdCourt) {
        this.holdCourt = holdCourt;
    }

    public void setLastOrderTime(Date lastOrderTime) {
        this.lastOrderTime = lastOrderTime;
    }

    public void setOrderEndTime(String orderEndTime) {
        this.orderEndTime = orderEndTime;
    }

    public void setLastMediationStatus(String lastMediationStatus) {
        this.lastMediationStatus = lastMediationStatus;
    }

    public void setCourtRoomName(String courtRoomName) {
        this.courtRoomName = courtRoomName;
    }

    public void setCaseType(String caseType) {
        this.caseType = caseType;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }

    public void setThirdCaseId(String thirdCaseId) {
        this.thirdCaseId = thirdCaseId;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }

    public void setUndertakeDepartment(String undertakeDepartment) {
        this.undertakeDepartment = undertakeDepartment;
    }

    public void setUndertakeUser(String undertakeUser) {
        this.undertakeUser = undertakeUser;
    }

    public void setUndertakeUserPhone(String undertakeUserPhone) {
        this.undertakeUserPhone = undertakeUserPhone;
    }

    public void setSuperviseType(String superviseType) {
        this.superviseType = superviseType;
    }

    public void setSuperviseUser(String superviseUser) {
        this.superviseUser = superviseUser;
    }

    public void setSuperviseUserPhone(String superviseUserPhone) {
        this.superviseUserPhone = superviseUserPhone;
    }

    public void setAuthFlag(Integer authFlag) {
        this.authFlag = authFlag;
    }

    public void setCallFlag(Integer callFlag) {
        this.callFlag = callFlag;
    }

    public void setCreatorType(String creatorType) {
        this.creatorType = creatorType;
    }

    public void setSchedulingInfo(List<SchedulingInfoResponseDTO> schedulingInfo) {
        this.schedulingInfo = schedulingInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetCaseInfoResponseDTO)) {
            return false;
        }
        GetCaseInfoResponseDTO other = (GetCaseInfoResponseDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$deleteStatus = this.getDeleteStatus();
        Boolean other$deleteStatus = other.getDeleteStatus();
        if (this$deleteStatus == null ? other$deleteStatus != null : !((Object)this$deleteStatus).equals(other$deleteStatus)) {
            return false;
        }
        String this$caseNumber = this.getCaseNumber();
        String other$caseNumber = other.getCaseNumber();
        if (this$caseNumber == null ? other$caseNumber != null : !this$caseNumber.equals(other$caseNumber)) {
            return false;
        }
        String this$caseCause = this.getCaseCause();
        String other$caseCause = other.getCaseCause();
        if (this$caseCause == null ? other$caseCause != null : !this$caseCause.equals(other$caseCause)) {
            return false;
        }
        String this$causeCode = this.getCauseCode();
        String other$causeCode = other.getCauseCode();
        if (this$causeCode == null ? other$causeCode != null : !this$causeCode.equals(other$causeCode)) {
            return false;
        }
        String this$courtName = this.getCourtName();
        String other$courtName = other.getCourtName();
        if (this$courtName == null ? other$courtName != null : !this$courtName.equals(other$courtName)) {
            return false;
        }
        String this$holdCourt = this.getHoldCourt();
        String other$holdCourt = other.getHoldCourt();
        if (this$holdCourt == null ? other$holdCourt != null : !this$holdCourt.equals(other$holdCourt)) {
            return false;
        }
        Date this$lastOrderTime = this.getLastOrderTime();
        Date other$lastOrderTime = other.getLastOrderTime();
        if (this$lastOrderTime == null ? other$lastOrderTime != null : !((Object)this$lastOrderTime).equals(other$lastOrderTime)) {
            return false;
        }
        String this$orderEndTime = this.getOrderEndTime();
        String other$orderEndTime = other.getOrderEndTime();
        if (this$orderEndTime == null ? other$orderEndTime != null : !this$orderEndTime.equals(other$orderEndTime)) {
            return false;
        }
        String this$lastMediationStatus = this.getLastMediationStatus();
        String other$lastMediationStatus = other.getLastMediationStatus();
        if (this$lastMediationStatus == null ? other$lastMediationStatus != null : !this$lastMediationStatus.equals(other$lastMediationStatus)) {
            return false;
        }
        String this$courtRoomName = this.getCourtRoomName();
        String other$courtRoomName = other.getCourtRoomName();
        if (this$courtRoomName == null ? other$courtRoomName != null : !this$courtRoomName.equals(other$courtRoomName)) {
            return false;
        }
        String this$caseType = this.getCaseType();
        String other$caseType = other.getCaseType();
        if (this$caseType == null ? other$caseType != null : !this$caseType.equals(other$caseType)) {
            return false;
        }
        String this$caseName = this.getCaseName();
        String other$caseName = other.getCaseName();
        if (this$caseName == null ? other$caseName != null : !this$caseName.equals(other$caseName)) {
            return false;
        }
        String this$thirdCaseId = this.getThirdCaseId();
        String other$thirdCaseId = other.getThirdCaseId();
        if (this$thirdCaseId == null ? other$thirdCaseId != null : !this$thirdCaseId.equals(other$thirdCaseId)) {
            return false;
        }
        String this$procedure = this.getProcedure();
        String other$procedure = other.getProcedure();
        if (this$procedure == null ? other$procedure != null : !this$procedure.equals(other$procedure)) {
            return false;
        }
        String this$undertakeDepartment = this.getUndertakeDepartment();
        String other$undertakeDepartment = other.getUndertakeDepartment();
        if (this$undertakeDepartment == null ? other$undertakeDepartment != null : !this$undertakeDepartment.equals(other$undertakeDepartment)) {
            return false;
        }
        String this$undertakeUser = this.getUndertakeUser();
        String other$undertakeUser = other.getUndertakeUser();
        if (this$undertakeUser == null ? other$undertakeUser != null : !this$undertakeUser.equals(other$undertakeUser)) {
            return false;
        }
        String this$undertakeUserPhone = this.getUndertakeUserPhone();
        String other$undertakeUserPhone = other.getUndertakeUserPhone();
        if (this$undertakeUserPhone == null ? other$undertakeUserPhone != null : !this$undertakeUserPhone.equals(other$undertakeUserPhone)) {
            return false;
        }
        String this$superviseType = this.getSuperviseType();
        String other$superviseType = other.getSuperviseType();
        if (this$superviseType == null ? other$superviseType != null : !this$superviseType.equals(other$superviseType)) {
            return false;
        }
        String this$superviseUser = this.getSuperviseUser();
        String other$superviseUser = other.getSuperviseUser();
        if (this$superviseUser == null ? other$superviseUser != null : !this$superviseUser.equals(other$superviseUser)) {
            return false;
        }
        String this$superviseUserPhone = this.getSuperviseUserPhone();
        String other$superviseUserPhone = other.getSuperviseUserPhone();
        if (this$superviseUserPhone == null ? other$superviseUserPhone != null : !this$superviseUserPhone.equals(other$superviseUserPhone)) {
            return false;
        }
        Integer this$authFlag = this.getAuthFlag();
        Integer other$authFlag = other.getAuthFlag();
        if (this$authFlag == null ? other$authFlag != null : !((Object)this$authFlag).equals(other$authFlag)) {
            return false;
        }
        Integer this$callFlag = this.getCallFlag();
        Integer other$callFlag = other.getCallFlag();
        if (this$callFlag == null ? other$callFlag != null : !((Object)this$callFlag).equals(other$callFlag)) {
            return false;
        }
        String this$creatorType = this.getCreatorType();
        String other$creatorType = other.getCreatorType();
        if (this$creatorType == null ? other$creatorType != null : !this$creatorType.equals(other$creatorType)) {
            return false;
        }
        List<SchedulingInfoResponseDTO> this$schedulingInfo = this.getSchedulingInfo();
        List<SchedulingInfoResponseDTO> other$schedulingInfo = other.getSchedulingInfo();
        return !(this$schedulingInfo == null ? other$schedulingInfo != null : !((Object)this$schedulingInfo).equals(other$schedulingInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetCaseInfoResponseDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $deleteStatus = this.getDeleteStatus();
        result = result * 59 + ($deleteStatus == null ? 43 : ((Object)$deleteStatus).hashCode());
        String $caseNumber = this.getCaseNumber();
        result = result * 59 + ($caseNumber == null ? 43 : $caseNumber.hashCode());
        String $caseCause = this.getCaseCause();
        result = result * 59 + ($caseCause == null ? 43 : $caseCause.hashCode());
        String $causeCode = this.getCauseCode();
        result = result * 59 + ($causeCode == null ? 43 : $causeCode.hashCode());
        String $courtName = this.getCourtName();
        result = result * 59 + ($courtName == null ? 43 : $courtName.hashCode());
        String $holdCourt = this.getHoldCourt();
        result = result * 59 + ($holdCourt == null ? 43 : $holdCourt.hashCode());
        Date $lastOrderTime = this.getLastOrderTime();
        result = result * 59 + ($lastOrderTime == null ? 43 : ((Object)$lastOrderTime).hashCode());
        String $orderEndTime = this.getOrderEndTime();
        result = result * 59 + ($orderEndTime == null ? 43 : $orderEndTime.hashCode());
        String $lastMediationStatus = this.getLastMediationStatus();
        result = result * 59 + ($lastMediationStatus == null ? 43 : $lastMediationStatus.hashCode());
        String $courtRoomName = this.getCourtRoomName();
        result = result * 59 + ($courtRoomName == null ? 43 : $courtRoomName.hashCode());
        String $caseType = this.getCaseType();
        result = result * 59 + ($caseType == null ? 43 : $caseType.hashCode());
        String $caseName = this.getCaseName();
        result = result * 59 + ($caseName == null ? 43 : $caseName.hashCode());
        String $thirdCaseId = this.getThirdCaseId();
        result = result * 59 + ($thirdCaseId == null ? 43 : $thirdCaseId.hashCode());
        String $procedure = this.getProcedure();
        result = result * 59 + ($procedure == null ? 43 : $procedure.hashCode());
        String $undertakeDepartment = this.getUndertakeDepartment();
        result = result * 59 + ($undertakeDepartment == null ? 43 : $undertakeDepartment.hashCode());
        String $undertakeUser = this.getUndertakeUser();
        result = result * 59 + ($undertakeUser == null ? 43 : $undertakeUser.hashCode());
        String $undertakeUserPhone = this.getUndertakeUserPhone();
        result = result * 59 + ($undertakeUserPhone == null ? 43 : $undertakeUserPhone.hashCode());
        String $superviseType = this.getSuperviseType();
        result = result * 59 + ($superviseType == null ? 43 : $superviseType.hashCode());
        String $superviseUser = this.getSuperviseUser();
        result = result * 59 + ($superviseUser == null ? 43 : $superviseUser.hashCode());
        String $superviseUserPhone = this.getSuperviseUserPhone();
        result = result * 59 + ($superviseUserPhone == null ? 43 : $superviseUserPhone.hashCode());
        Integer $authFlag = this.getAuthFlag();
        result = result * 59 + ($authFlag == null ? 43 : ((Object)$authFlag).hashCode());
        Integer $callFlag = this.getCallFlag();
        result = result * 59 + ($callFlag == null ? 43 : ((Object)$callFlag).hashCode());
        String $creatorType = this.getCreatorType();
        result = result * 59 + ($creatorType == null ? 43 : $creatorType.hashCode());
        List<SchedulingInfoResponseDTO> $schedulingInfo = this.getSchedulingInfo();
        result = result * 59 + ($schedulingInfo == null ? 43 : ((Object)$schedulingInfo).hashCode());
        return result;
    }

    public String toString() {
        return "GetCaseInfoResponseDTO(id=" + this.getId() + ", deleteStatus=" + this.getDeleteStatus() + ", caseNumber=" + this.getCaseNumber() + ", caseCause=" + this.getCaseCause() + ", causeCode=" + this.getCauseCode() + ", courtName=" + this.getCourtName() + ", holdCourt=" + this.getHoldCourt() + ", lastOrderTime=" + this.getLastOrderTime() + ", orderEndTime=" + this.getOrderEndTime() + ", lastMediationStatus=" + this.getLastMediationStatus() + ", courtRoomName=" + this.getCourtRoomName() + ", caseType=" + this.getCaseType() + ", caseName=" + this.getCaseName() + ", thirdCaseId=" + this.getThirdCaseId() + ", procedure=" + this.getProcedure() + ", undertakeDepartment=" + this.getUndertakeDepartment() + ", undertakeUser=" + this.getUndertakeUser() + ", undertakeUserPhone=" + this.getUndertakeUserPhone() + ", superviseType=" + this.getSuperviseType() + ", superviseUser=" + this.getSuperviseUser() + ", superviseUserPhone=" + this.getSuperviseUserPhone() + ", authFlag=" + this.getAuthFlag() + ", callFlag=" + this.getCallFlag() + ", creatorType=" + this.getCreatorType() + ", schedulingInfo=" + this.getSchedulingInfo() + ")";
    }
}

