package com.beiming.odr.peace.im.api.dto.response;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * package: com.beiming.odr.peace.im.dto.response
 * describe: 未读消息列表响应对象
 * create_user: xiet
 * create_date: 2019/1/23 create_time: 2:11 PM
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UnreadMessageListResponseDTO implements Serializable {

  /**
   * 房间ID
   */
  private String roomId;

  /**
   * 最后更新时间
   */
  private Long lastUpdateTime;

  /**
   * 消息内容
   */
  private String messageContent;

  /**
   * 未读数
   */
  private Integer unreadCount;

  /**
   * 用户角色类型
   */
  private String userRoleType;

  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 用户ID
   */
  private String userId;

  /**
   * 消息类型
   */
  private String messageType;

  /**
   * 消息类型
   */
  private String messageResource;

}
