package com.beiming.odr.peace.im.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.peace.im.api.dto.response.RoomUnreadCountResponseDTO;
import com.beiming.odr.peace.im.api.dto.response.SubjectUnreadCountResponseDTO;
import com.beiming.odr.peace.im.api.dto.response.SubjectUnreadMessageListResponseDTO;
import com.beiming.odr.peace.im.api.dto.response.UnreadMessageListResponseDTO;
import java.util.ArrayList;

/**
 * package: com.beiming.odr.peace.im.api describe: 未读消息API create_user: xiet create_date: 2019/1/23
 * create_time: 4:20 PM
 **/
public interface UnreadMessageApi {

  /**
   * 通过用户ID获取调解室未读消息数
   */
  DubboResult<ArrayList<SubjectUnreadCountResponseDTO>> getUnreadCountByUserId(String userId);

  /**
   * 通过用户ID和调解室ID获取聊天室未读消息数列表
   */
  DubboResult<ArrayList<RoomUnreadCountResponseDTO>> getUnreadCountByUserIdAndSubjectId(String userId,
      String subjectId);

  /**
   * 通过用户ID获取调解室未读消息列表
   * 返回所有调解室未读消息
   */
  DubboResult<ArrayList<SubjectUnreadMessageListResponseDTO>> getUnreadMessageListByUserId(String userId);

  /**
   * 通过用户ID和调解室ID获取聊天室未读消息列表
   */
  DubboResult<ArrayList<UnreadMessageListResponseDTO>> getUnreadMessageListByUserIdAndSubjectId(
      String userId, String subjectId);

  /**
   * 关闭法庭
   * 提交测试
   */
  DubboResult closeCourt(String courtCode, String caseNumberCode, String caseOrder);


  /**
   * 关闭私聊聊天室，因为语音通话，所以需要关闭
   *
   * @param roomIdStr 房间id数组
   */
  void closeChatRoom(String roomIdStr);
}
