/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.convert;

import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.framework.util.UUIDUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingUserRequestMicroDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMeetingIntranetRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantAgentInfoMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantInfoRequestDTO;
import com.beiming.odr.referee.dto.requestdto.VisitSystemUserReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DTOCheckFieldConvert {
    private static final Logger log = LoggerFactory.getLogger(DTOCheckFieldConvert.class);

    public static void checkLitigantInfoRequestDTO(List<LitigantInfoRequestDTO> list) {
        for (LitigantInfoRequestDTO one : list) {
            if (one.getLitigantType() == null) {
                AssertUtils.assertNotNull((Object)one.getUserName(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u5f53\u4e8b\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (!"1".equals(one.getLitigantType().toString())) continue;
            AssertUtils.assertNotNull((Object)one.getUserName(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u5f53\u4e8b\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void checkVisitDsrInfoRequestDTO(List<VisitSystemUserReqDTO> list) {
        for (VisitSystemUserReqDTO dto : list) {
            if (dto.getUserType() == null) {
                AssertUtils.assertNotNull((Object)dto.getUserName(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u7533\u8bf7\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if ("APPLICANT".equals(dto.getUserType().toString())) {
                AssertUtils.assertNotNull((Object)dto.getUserName(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u7533\u8bf7\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!"ASSOCIATE".equals(dto.getUserType().toString())) continue;
            AssertUtils.assertNotNull((Object)dto.getUserName(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u540c\u884c\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.assertNotNull((Object)dto.getUserCard(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u540c\u884c\u4eba\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.assertNotNull((Object)dto.getUserSex(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u540c\u884c\u4eba\u6027\u522b\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.assertNotNull((Object)dto.getUserMobilePhone(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u540c\u884c\u4eba\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.assertNotNull((Object)dto.getUserIsLawyer(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u540c\u884c\u4eba\u662f\u5426\u672a\u5f8b\u5e08\u9009\u9879\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.assertNotNull((Object)dto.getUserFaceUrl(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u540c\u884c\u4eba\u514d\u51a0\u7167\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void checkIntranetAddMeetingDTO(AddMeetingIntranetRequestDTO dto) {
        List litigantList = dto.getLitigantList();
        for (LitigantInfoRequestDTO one : litigantList) {
            AssertUtils.assertNotNull((Object)one.getUserName(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u5f53\u4e8b\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.assertNotNull((Object)one.getMeetingUserType(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u5f53\u4e8b\u4eba\u8bc9\u8bbc\u5730\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List agentList = dto.getAgentList();
        if (CollectionUtils.isEmpty((Collection)agentList)) {
            return;
        }
        for (LitigantAgentInfoMicroRequestDTO one : agentList) {
            AssertUtils.assertNotNull((Object)one.getUserName(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u4ee3\u7406\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.assertNotNull((Object)one.getMobilePhone(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u4ee3\u7406\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.assertNotNull((Object)one.getMeetingUserType(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u88ab\u4ee3\u7406\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.assertNotNull((Object)one.getAgentType(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u4ee3\u7406\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void buildIntranetTempId(AddMeetingIntranetRequestDTO dto) {
        HashMap<String, LitigantInfoRequestDTO> litigantMap = new HashMap<String, LitigantInfoRequestDTO>();
        List litigantList = dto.getLitigantList();
        for (LitigantInfoRequestDTO one : litigantList) {
            one.setUserTempId(UUIDUtils.fullUUID());
            if (StringUtils.isBlank((String)one.getMobilePhone())) continue;
            litigantMap.put(one.getMobilePhone(), one);
        }
        List agentList = dto.getAgentList();
        if (CollectionUtils.isEmpty((Collection)agentList)) {
            return;
        }
        for (LitigantAgentInfoMicroRequestDTO one : agentList) {
            one.setUserTempId(UUIDUtils.fullUUID());
            String agentParentPhone = one.getAgentParentPhoneList();
            if (StringUtils.isBlank((String)agentParentPhone)) continue;
            String[] mobilePhoneList = agentParentPhone.split(",");
            one.setAgentParentUserTempIdList(DTOCheckFieldConvert.buildTempIdList(mobilePhoneList, litigantMap));
        }
    }

    public static void buildIntranetAddUserTempId(AddMediationMeetingUserRequestMicroDTO dto, List<MediationRoomUserInfoResDTO> oldUserList) {
        List agentList;
        HashMap<String, LitigantInfoRequestDTO> litigantMap = new HashMap<String, LitigantInfoRequestDTO>();
        HashMap<String, LitigantInfoRequestDTO> litigantTempUserIdMap = new HashMap<String, LitigantInfoRequestDTO>();
        ArrayList<LitigantInfoRequestDTO> litigantList = dto.getLitigantList();
        HashSet<String> mobilePhoneSet = new HashSet<String>();
        HashSet<String> tempUserIdSet = new HashSet<String>();
        if (!CollectionUtils.isEmpty((Collection)litigantList)) {
            for (LitigantInfoRequestDTO one : litigantList) {
                one.setUserTempId(UUIDUtils.fullUUID());
                if (!StringUtils.isBlank((String)one.getMobilePhone())) {
                    litigantMap.put(one.getMobilePhone(), one);
                    mobilePhoneSet.add(one.getMobilePhone());
                }
                if (StringUtils.isBlank((String)one.getUserTempId())) continue;
                litigantTempUserIdMap.put(one.getUserTempId(), one);
                tempUserIdSet.add(one.getUserTempId());
            }
        } else {
            litigantList = new ArrayList<LitigantInfoRequestDTO>();
        }
        if (CollectionUtils.isEmpty((Collection)(agentList = dto.getAgentList()))) {
            return;
        }
        if (!CollectionUtils.isEmpty(oldUserList)) {
            LitigantInfoRequestDTO litigantDTO = null;
            for (MediationRoomUserInfoResDTO oldUser : oldUserList) {
                litigantDTO = new LitigantInfoRequestDTO();
                litigantDTO.setUserTempId(oldUser.getRemark());
                litigantDTO.setUserId(oldUser.getUserId());
                litigantDTO.setUserName(oldUser.getUserName());
                litigantDTO.setMobilePhone(oldUser.getMobilePhone());
                litigantDTO.setMeetingUserType(DTOCheckFieldConvert.getMeetingUserType(oldUser.getMeetingUserType()));
                litigantDTO.setIdCard(oldUser.getIdCard());
                litigantDTO.setAuthStatus(oldUser.getAuthStatus());
                litigantMap.put(oldUser.getMobilePhone(), litigantDTO);
                litigantTempUserIdMap.put(oldUser.getRemark(), litigantDTO);
            }
        }
        for (LitigantAgentInfoMicroRequestDTO one : agentList) {
            LitigantInfoRequestDTO litigantInfoRequestDTO;
            one.setUserTempId(UUIDUtils.fullUUID());
            log.info("\u4ee3\u7406\u4eba\u4fe1\u606f\uff1a{}", (Object)one.toString());
            log.info("\u5f53\u4e8b\u4eba\u4eba\u4fe1\u606f\uff1a{}", (Object)((Object)litigantTempUserIdMap).toString());
            log.info("\u4e34\u65f6id\u4fe1\u606f\uff1a{}", (Object)((Object)tempUserIdSet).toString());
            if (!StringUtils.isBlank((String)one.getAgentParentUserTempIdList())) {
                String agentParentUserTempId = one.getAgentParentUserTempIdList();
                String[] userTempIdList = agentParentUserTempId.split(",");
                one.setAgentParentUserTempIdList(DTOCheckFieldConvert.buildTempIdListByTempUserId(userTempIdList, litigantTempUserIdMap));
                for (String tempUserId : userTempIdList) {
                    if (tempUserIdSet.contains(tempUserId)) continue;
                    tempUserIdSet.add(tempUserId);
                    litigantInfoRequestDTO = (LitigantInfoRequestDTO)litigantTempUserIdMap.get(tempUserId);
                    litigantList.add(litigantInfoRequestDTO);
                }
                continue;
            }
            if (StringUtils.isBlank((String)one.getAgentParentPhoneList())) continue;
            String agentParentPhone = one.getAgentParentPhoneList();
            String[] mobilePhoneList = agentParentPhone.split(",");
            one.setAgentParentUserTempIdList(DTOCheckFieldConvert.buildTempIdList(mobilePhoneList, litigantMap));
            for (String mobilePhone : mobilePhoneList) {
                if (mobilePhoneSet.contains(mobilePhone)) continue;
                mobilePhoneSet.add(mobilePhone);
                litigantInfoRequestDTO = (LitigantInfoRequestDTO)litigantMap.get(mobilePhone);
                litigantList.add(litigantInfoRequestDTO);
            }
        }
        dto.setLitigantList(litigantList);
    }

    public static String buildTempIdList(String[] mobilePhoneList, Map<String, LitigantInfoRequestDTO> litigantMap) {
        StringBuffer stringbuffer = new StringBuffer();
        for (String mobilePhone : mobilePhoneList) {
            LitigantInfoRequestDTO litigant = litigantMap.get(mobilePhone);
            if (stringbuffer != null && stringbuffer.length() > 0) {
                stringbuffer.append(",");
            }
            stringbuffer.append(litigant.getUserTempId());
        }
        return stringbuffer.toString();
    }

    public static String buildTempIdListByTempUserId(String[] tempUserIdList, Map<String, LitigantInfoRequestDTO> litigantTempUserIdMap) {
        StringBuffer stringbuffer = new StringBuffer();
        for (String tempUserId : tempUserIdList) {
            LitigantInfoRequestDTO litigant = litigantTempUserIdMap.get(tempUserId);
            if (stringbuffer != null && stringbuffer.length() > 0) {
                stringbuffer.append(",");
            }
            stringbuffer.append(litigant.getUserTempId());
        }
        return stringbuffer.toString();
    }

    public static MeetingUserTypeEnum getMeetingUserType(String meetingUserType) {
        if (MeetingUserTypeEnum.APPLICANT.toString().equals(meetingUserType)) {
            return MeetingUserTypeEnum.APPLICANT;
        }
        if (MeetingUserTypeEnum.RESPONDENT.toString().equals(meetingUserType)) {
            return MeetingUserTypeEnum.RESPONDENT;
        }
        if (MeetingUserTypeEnum.APPLICANT_AGENT.toString().equals(meetingUserType)) {
            return MeetingUserTypeEnum.APPLICANT_AGENT;
        }
        if (MeetingUserTypeEnum.RESPONDENT_AGENT.toString().equals(meetingUserType)) {
            return MeetingUserTypeEnum.RESPONDENT_AGENT;
        }
        if (MeetingUserTypeEnum.MEDIATOR.toString().equals(meetingUserType)) {
            return MeetingUserTypeEnum.MEDIATOR;
        }
        if (MeetingUserTypeEnum.CLERK.toString().equals(meetingUserType)) {
            return MeetingUserTypeEnum.CLERK;
        }
        return null;
    }
}

