/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.document.api.AttachmentApi;
import com.beiming.odr.peace.common.enums.ColumnEnums;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.CaseListRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UpdateMediationMeetingMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.CaseListResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.GetScheduleIdResponseDTO;
import com.beiming.odr.peace.service.CaseService;
import com.beiming.odr.peace.service.ChatService;
import com.beiming.odr.referee.api.CaseRoomMicroApi;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.requestdto.CaseListMicroRequestDTO;
import com.beiming.odr.referee.dto.responsedto.CaseListMicroResponseDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingRoomInfoResDTO;
import com.beiming.odr.referee.enums.MediationMeetingTypeEnum;
import com.beiming.odr.user.api.DictionaryServiceApi;
import com.beiming.odr.user.api.dto.DictionaryInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.DictionaryReqDTO;
import com.beiming.odr.user.api.dto.responsedto.DictionaryResDTO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CaseServiceImpl
implements CaseService {
    private static final Logger log = LoggerFactory.getLogger(CaseServiceImpl.class);
    @Resource
    private CaseRoomMicroApi caseRoomMicroApi;
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Resource
    private DictionaryServiceApi dictionaryServiceApi;
    @Resource
    private ChatService chatService;
    @Resource
    private AttachmentApi attachmentApi;

    @Override
    public PageInfo<CaseListResponseDTO> getCaseList(CaseListRequestDTO dto) {
        CaseListMicroRequestDTO requestDto = this.buildCaseListMicroRequestDTO(dto);
        ArrayList<CaseListResponseDTO> result = new ArrayList<CaseListResponseDTO>();
        if (dto.getUserId() != null) {
            requestDto.setUserId(dto.getUserId());
        } else {
            requestDto.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        }
        requestDto.setMediationMeetingType(MediationMeetingTypeEnum.MEDIATION_ROOM.toString());
        log.info("\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)requestDto));
        DubboResult dubboResult = this.caseRoomMicroApi.getCaseList(requestDto);
        if (dubboResult.getData() == null || ((PageInfo)dubboResult.getData()).getList() == null) {
            return new PageInfo(result, 0, dto.getPageIndex().intValue(), dto.getPageSize().intValue());
        }
        PageInfo pageInfo = (PageInfo)dubboResult.getData();
        List list = pageInfo.getList();
        CaseListResponseDTO caseInfo = null;
        for (CaseListMicroResponseDTO one : list) {
            caseInfo = new CaseListResponseDTO();
            caseInfo.setBizRoomId(one.getBizRoomId());
            caseInfo.setName(one.getName());
            caseInfo.setCaseStatus(one.getCaseStatus());
            caseInfo.setOrderTime(this.buildOrderTime(one));
            caseInfo.setScheduleId(one.getScheduleId());
            caseInfo.setCaseSource(one.getCaseSource());
            caseInfo.setCanUpdateUser(Boolean.valueOf(true));
            result.add(caseInfo);
        }
        return new PageInfo(result, pageInfo.getTotalRows(), dto.getPageIndex().intValue(), dto.getPageSize().intValue());
    }

    public CaseListMicroRequestDTO buildCaseListMicroRequestDTO(CaseListRequestDTO dto) {
        CaseListMicroRequestDTO resultDto = new CaseListMicroRequestDTO();
        resultDto.setPageIndex(dto.getPageIndex());
        resultDto.setPageSize(dto.getPageSize());
        resultDto.setName(dto.getName());
        resultDto.setCaseStatus(dto.getCaseStatus());
        resultDto.setCaseSource(dto.getCaseSource());
        resultDto.setTrialStatus(dto.getTrialStatus());
        resultDto.setRoleCodeList(dto.getRoleCodeList());
        resultDto.setFlag(Integer.valueOf(1));
        return resultDto;
    }

    public String buildOrderTime(CaseListMicroResponseDTO dto) {
        if (dto.getOrderTime() == null) {
            return "";
        }
        SimpleDateFormat startFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String startTime = startFormat.format(dto.getOrderTime());
        if (dto.getExpandAttribute() == null) {
            return startTime;
        }
        JSONObject json = JSONObject.parseObject((String)dto.getExpandAttribute());
        if (json.get((Object)ColumnEnums.ORDER_END_TIME.desc()) != null) {
            String orderEndTime = json.get((Object)ColumnEnums.ORDER_END_TIME.desc()).toString();
            log.info("orderEndTime = {}", (Object)orderEndTime);
            if (orderEndTime.length() > 6) {
                long lt = new Long(orderEndTime);
                Date date = new Date(lt);
                SimpleDateFormat startFormatEnd = new SimpleDateFormat("HH:mm");
                orderEndTime = startFormatEnd.format(date);
            }
            return startTime + "--" + orderEndTime;
        }
        return startTime;
    }

    @Override
    public GetScheduleIdResponseDTO getScheduleId(CommonIdRequestDTO dto) {
        DubboResult scheduleIdResult = this.caseRoomMicroApi.maxScheduleId(dto.getId());
        AssertUtils.assertTrue((scheduleIdResult.getData() != null ? 1 : 0) != 0, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u83b7\u53d6\u5ead\u6b21\u5931\u8d25");
        GetScheduleIdResponseDTO result = new GetScheduleIdResponseDTO();
        result.setScheduleId((Integer)scheduleIdResult.getData());
        String appName = AppNameContextHolder.getAppName();
        boolean disabled = true;
        DictionaryReqDTO dictionaryDto = new DictionaryReqDTO("INPUT_SCHEDULE_ID", null);
        DubboResult dubboResult = this.dictionaryServiceApi.searchDictionaryInfo(dictionaryDto);
        if (dubboResult != null && dubboResult.getData() != null && !CollectionUtils.isEmpty((Collection)((DictionaryResDTO)dubboResult.getData()).getData())) {
            List data = ((DictionaryResDTO)dubboResult.getData()).getData();
            for (DictionaryInfoDTO one : data) {
                if (!appName.equals(one.getValue())) continue;
                disabled = false;
                break;
            }
        }
        result.setDisabled(Boolean.valueOf(disabled));
        return result;
    }

    @Override
    public void updateCaseOrderTime(UpdateMediationMeetingMicroRequestDTO dto) {
        DubboResult meetingInfo = this.mediationRoomApi.selectCaseMeetingInfo(dto.getId());
        AssertUtils.assertTrue((meetingInfo.getData() != null ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u83b7\u53d6\u6392\u671f\u4fe1\u606f\u5931\u8d25");
        CaseMeetingRoomInfoResDTO caseMeetingRoomInfo = (CaseMeetingRoomInfoResDTO)meetingInfo.getData();
        if ("INIT".equals(caseMeetingRoomInfo.getMediationStatus())) {
            if (caseMeetingRoomInfo.getExpandAttribute() != null) {
                JSONObject json = JSONObject.parseObject((String)caseMeetingRoomInfo.getExpandAttribute());
                json.put(ColumnEnums.UNDERTAKE_DEPARTMENT.desc(), (Object)dto.getUndertakeDepartment());
                json.put(ColumnEnums.ORDER_END_TIME.desc(), (Object)dto.getOrderEndTime());
                caseMeetingRoomInfo.setExpandAttribute((String)JSON.parseObject((String)JSON.toJSONString((Object)json), String.class));
            }
            caseMeetingRoomInfo.setMediationType(dto.getCourtRoomCode());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String orderTime = sdf.format(dto.getOrderTime());
            caseMeetingRoomInfo.setOrderTime(orderTime);
            this.mediationRoomApi.updateCaseOrderTime(caseMeetingRoomInfo);
            String orderEndTime = orderTime.substring(0, 11).concat(dto.getOrderEndTime()).concat(":00");
            this.mediationRoomApi.updateMediationRoomMore(caseMeetingRoomInfo.getId(), orderTime, orderEndTime, dto.getLeadTime(), dto.getCourtRoomCode(), dto.getCourtRoomName());
        } else {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u5df2\u5f00\u59cb\u7684\u5ead\u5ba1\u65e0\u6cd5\u4fee\u6539\u6392\u671f");
        }
    }

    @Override
    public void reschedule(List<Long> idList) {
        this.mediationRoomApi.reschedule(idList);
    }
}

