/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.processor;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.context.DataSourceContextHolder;
import com.beiming.framework.domain.DubboResultCode;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.exception.DubboBusinessException;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.common.enums.RedisKeyEnum;
import com.beiming.odr.peace.domain.dto.CreateDocMqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SuspectReportRequestDTO;
import com.beiming.odr.peace.service.client.ClerkRecordService;
import com.beiming.pigeons.api.consumer.rocketmq.RocketMsgProcessor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDocProcessor
implements RocketMsgProcessor<CreateDocMqDTO> {
    private static final Logger log = LoggerFactory.getLogger(CreateDocProcessor.class);
    private static long timeout = 1L;
    private static TimeUnit timeE = TimeUnit.MINUTES;
    private static RedisKeyEnum redisKeyE = RedisKeyEnum.CREATE_DOCX;
    @Resource
    RedisService redisService;
    @Resource
    private ClerkRecordService clerkRecordService;

    public String process(CreateDocMqDTO mqDTO) {
        String lockKey;
        Boolean succeFlag;
        Boolean lockFlag;
        block6: {
            log.info("[DockingSysProcessor.process] @DockingSysProcessor {}", (Object)mqDTO.toString());
            lockFlag = false;
            succeFlag = false;
            lockKey = mqDTO.getBizKey();
            try {
                String appName = mqDTO.getAppName();
                AssertUtils.assertHasText((String)appName, (ResultCode)DubboResultCodeEnums.PARAM_ERROR, (String)"APPNAME\u4e3a\u7a7a");
                AppNameContextHolder.setAppName((String)appName);
                DataSourceContextHolder.setDBByAppName((String)appName);
                lockFlag = this.redisService.setIfAbsent((RedisKey)redisKeyE, lockKey, (Object)lockKey, timeout, timeE);
                log.info("[DockingSysProcessor.process] consume, lockFlag {} bizKey {}", (Object)lockFlag, (Object)lockKey);
                if (!lockFlag.booleanValue()) break block6;
                this.checkBasicInfoValid(mqDTO);
                SuspectReportRequestDTO suspectReportRequestDTO = new SuspectReportRequestDTO(mqDTO.getObjectId());
                this.clerkRecordService.createSuspectReport(suspectReportRequestDTO, mqDTO.getJwtToken());
                succeFlag = true;
            }
            catch (Exception e) {
                try {
                    log.error("[DockingSysProcessor.process] consume fail, bizKey {} error {}", (Object)lockKey, (Object)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    log.info("[DockingSysProcessor.process] consume, lockFlag {} succeFlag {} bizKey {}", new Object[]{lockFlag, succeFlag, lockKey});
                    if (lockFlag.booleanValue() && !succeFlag.booleanValue()) {
                        this.redisService.delete((RedisKey)redisKeyE, lockKey);
                    }
                    throw throwable;
                }
            }
        }
        log.info("[DockingSysProcessor.process] consume, lockFlag {} succeFlag {} bizKey {}", new Object[]{lockFlag, succeFlag, lockKey});
        if (lockFlag.booleanValue() && !succeFlag.booleanValue()) {
            this.redisService.delete((RedisKey)redisKeyE, lockKey);
        }
        return null;
    }

    private void checkBasicInfoValid(CreateDocMqDTO mqDTO) {
        if (null == mqDTO.getObjectId() || mqDTO.getObjectId().equals(0L)) {
            throw new DubboBusinessException((DubboResultCode)DubboResultCodeEnums.INTERNAL_ERROR, "\u4f20\u8f93\u7684\u6d88\u606f\u6848\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

