/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.util;

import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSACoder {
    private static final Logger log = LoggerFactory.getLogger(RSACoder.class);
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";
    public static final String CHARSET = "UTF-8";

    public static byte[] decryptBASE64(String key) {
        return Base64.decodeBase64((String)key);
    }

    public static String encryptBASE64(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static String sign(String data, String privateKey) throws Exception {
        byte[] keyBytes = RSACoder.decryptBASE64(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(priKey);
        signature.update(RSACoder.decryptBASE64(data));
        return RSACoder.encryptBASE64(signature.sign());
    }

    public static boolean verify(String data, String publicKey, String sign) throws Exception {
        byte[] keyBytes = RSACoder.decryptBASE64(publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey pubKey = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(pubKey);
        signature.update(RSACoder.decryptBASE64(data));
        return signature.verify(RSACoder.decryptBASE64(sign));
    }

    public static String decryptByPrivateKey(String data, String key) throws Exception {
        byte[] keyBytes = RSACoder.decryptBASE64(key);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        RSAPrivateKey privateKey = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, privateKey);
        return new String(RSACoder.rsaSplitCodec(cipher, 2, RSACoder.decryptBASE64(data), privateKey.getModulus().bitLength()), CHARSET);
    }

    public static String decryptByPublicKey(String data, String key) throws Exception {
        byte[] keyBytes = RSACoder.decryptBASE64(key);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        RSAPublicKey publicKey = (RSAPublicKey)keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, publicKey);
        return new String(RSACoder.rsaSplitCodec(cipher, 2, RSACoder.decryptBASE64(data), publicKey.getModulus().bitLength()), CHARSET);
    }

    public static String encryptByPublicKey(String data, String key) throws Exception {
        byte[] keyBytes = RSACoder.decryptBASE64(key);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        RSAPublicKey publicKey = (RSAPublicKey)keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, publicKey);
        return RSACoder.encryptBASE64(RSACoder.rsaSplitCodec(cipher, 1, data.getBytes(CHARSET), publicKey.getModulus().bitLength()));
    }

    public static String encryptByPrivateKey(String data, String key) throws Exception {
        byte[] keyBytes = RSACoder.decryptBASE64(key);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        RSAPrivateKey privateKey = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, privateKey);
        return RSACoder.encryptBASE64(RSACoder.rsaSplitCodec(cipher, 1, data.getBytes(CHARSET), privateKey.getModulus().bitLength()));
    }

    public static Map<String, String> initKey() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put(PUBLIC_KEY, RSACoder.encryptBASE64(keyPair.getPublic().getEncoded()));
        keyMap.put(PRIVATE_KEY, RSACoder.encryptBASE64(keyPair.getPrivate().getEncoded()));
        return keyMap;
    }

    public static Map<String, String> initKeyMap(int number) throws Exception {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(1024);
        for (int i = 0; i < number; ++i) {
            KeyPair keyPair = keyPairGen.generateKeyPair();
            String publicKey = RSACoder.encryptBASE64(keyPair.getPublic().getEncoded());
            String privateKey = RSACoder.encryptBASE64(keyPair.getPrivate().getEncoded());
            keyMap.put(publicKey, privateKey);
        }
        return keyMap;
    }

    private static byte[] rsaSplitCodec(Cipher cipher, int opmode, byte[] datas, int keySize) throws Exception {
        int maxBlock = 0;
        maxBlock = opmode == 2 ? keySize / 8 : keySize / 8 - 11;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        try {
            while (datas.length > offSet) {
                byte[] buff = datas.length - offSet > maxBlock ? cipher.doFinal(datas, offSet, maxBlock) : cipher.doFinal(datas, offSet, datas.length - offSet);
                out.write(buff, 0, buff.length);
                offSet = ++i * maxBlock;
            }
        }
        catch (Exception e) {
            log.error("RSA\u52a0\u5bc6\u6216\u8005\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        byte[] resultDatas = out.toByteArray();
        return resultDatas;
    }

    public static void main(String[] args) throws Exception {
        Map<String, String> keyMap = RSACoder.initKey();
        String publicKey = keyMap.get(PUBLIC_KEY);
        String privateKey = keyMap.get(PRIVATE_KEY);
        System.out.println("\u516c\u94a5\t\r" + publicKey);
        System.out.println("\u79c1\u94a5\t\r" + privateKey);
        System.err.println("\u516c\u94a5\u52a0\u5bc6\u2014\u2014\u79c1\u94a5\u89e3\u5bc6");
        String inputStr = "\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11\u563f\u563f\u563f\u563f\u563f";
        String encodedData = RSACoder.encryptByPublicKey(inputStr, publicKey);
        String decodedData = RSACoder.decryptByPrivateKey(encodedData, privateKey);
        System.err.println("\u52a0\u5bc6\u524d: " + inputStr + "\n\r\u89e3\u5bc6\u540e: " + decodedData);
        System.out.println("\u89e3\u5bc6\u7684\u7ed3\u679c\u662f\u5426\u6b63\u786e:\n" + inputStr.equals(decodedData));
        String encodedData2 = RSACoder.encryptByPrivateKey(inputStr, privateKey);
        String decodedData2 = RSACoder.decryptByPublicKey(encodedData2, publicKey);
        System.err.println("\u52a0\u5bc6\u524d2: " + inputStr + "\n\r\u89e3\u5bc6\u540e2: " + decodedData2);
        System.out.println("\u89e3\u5bc6\u7684\u7ed3\u679c\u662f\u5426\u6b63\u786e:\n" + inputStr.equals(decodedData2));
    }

    public static void dec() throws Exception {
        String decstr = "VkzvfmFZGas3ZdCTl/IYk4BUvWLeUqjIheUMFGTbE8CJwZB0NowdVJ3yiHJA9/ErpXSvW4faRWl2ymihH1wS0gieS4z3n5pGqX7jv5PrkM/UCsRbM4ygM7patlyObkCqTvnMnsrd39V8yf0VkhVY4E/DyHz5K2kPVlVTsboJfBk=";
        String privateKey = "MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAIdt+NX5EhgB8bl7Y53vZgRsjZW02VYleZ+hPSclSScp7KApblkAKpGMEuGmBNT65Hz4kmB1LlfmP6ACpaIFZkxy/SKVZTKLa/6MMLKrXIfwrLusJlubkmJ9TFl6Y2+BeWo6edbUBDlNMA+BVXzFitqBzqGg8AEr8kiHMUn8FQ3tAgMBAAECgYABX8tLmIhnd/WU9TyQiLJXTyasozYlWqH+TauKLyWr4RAGnAUDoC3OZkZ2xbF828LfxcHueqHqwGpa3EwD9dwQ3L38L+EcN8BSiTPvdPohm4Ybz0RgzN73tddwYoMOq3kTluE5NNIqL/jIy7cHGnpPpvjYuKIg95Ucl99ZtKM+gQJBAMA9wBEQhtqeAMt2lxJLAV/3McxVWzXLUuJYM+eYODvQzMlN1WHm9PukoP8ELjKn7Qk85mDr/8olfIMOVbgH5I0CQQC0WKCMTO8cxWlXENr1O6V+uaUP3UtejXpQNqh6wYWZrZh0UtqMJh4nmDmTtXeR9PiGnvAwrMXS8tcvqLLTqWbhAkBhFA3U0Dq5VYbjOEzL0RKtqn/8RrJbtQRzBsWXU1g6ZJO1qFd0LBRUq2sdvLeznvdlbdqM4UB3jXyWFfwVhe7VAkBdnqhxTLrP/7boaKqRpY4K1ApYyvMGOYFmRIl/eBiHp3M954jmOh9rRH2XLRvOHBIrqDRdwELNeBy28+cpM4ZhAkB40n/cBzY2WTCTQyRrk/vf9r2AEEHe8pRVKMw1Jkd55qyn+LGH4qVU+csHAmtKaN/FsOLFyAdbUZv/FVYVa97q";
        String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCHbfjV+RIYAfG5e2Od72YEbI2VtNlWJXmfoT0nJUknKeygKW5ZACqRjBLhpgTU+uR8+JJgdS5X5j+gAqWiBWZMcv0ilWUyi2v+jDCyq1yH8Ky7rCZbm5JifUxZemNvgXlqOnnW1AQ5TTAPgVV8xYragc6hoPABK/JIhzFJ/BUN7QIDAQAB";
        String str = "\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11\u6211\u5f97\u610f\u7684\u7b11\u6211\u53c8\u5f97\u610f\u7684\u7b11";
        String kk = RSACoder.encryptByPublicKey(str, publicKey);
        String decodedData = RSACoder.decryptByPrivateKey(kk, privateKey);
        System.out.println("\u89e3\u5bc6\u7684\u7ed3\u679c:\n" + decodedData);
        System.out.println("\u89e3\u5bc6\u7684\u7ed3\u679c\u662f\u5426\u6b63\u786e:\n" + str.equals(decodedData));
    }
}

