/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.user.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.utils.JavaFileUtil;
import com.beiming.odr.peace.service.backend.user.UserDubboService;
import com.beiming.odr.user.api.UserServiceApi;
import com.beiming.odr.user.api.UserServiceSecondApi;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.CaseUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RealNameAuthenticationReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CaseUserRegisterResDTO;
import com.beiming.odr.user.api.dto.responsedto.CommonUserSearchResDTO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserDubboServiceImpl
implements UserDubboService {
    private static final Logger log = LoggerFactory.getLogger(UserDubboServiceImpl.class);
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private UserServiceSecondApi userServiceSecondApi;

    @Override
    public DubboResult<CaseUserRegisterResDTO> caseUserRegister(CaseUserRegisterReqDTO reqDTO) {
        log.info("{} core request reqDTO {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        DubboResult dubboResult = this.userServiceApi.caseUserregister(reqDTO);
        log.info("dubbo result=============={}", (Object)dubboResult);
        return dubboResult;
    }

    @Override
    public CommonUserSearchResDTO searchCommonUser(Long userId) {
        try {
            CommonIdReqDTO idReqDTO = new CommonIdReqDTO();
            idReqDTO.setId(userId);
            DubboResult dubboResult = this.userServiceApi.searchCommonUser(idReqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (CommonUserSearchResDTO)dubboResult.getData();
            }
            log.error("{} reqDTO {} result {}", new Object[]{JavaFileUtil.getMethodName(), userId, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public Boolean isRealName(Long userId) {
        Boolean isRealName = false;
        CommonUserSearchResDTO commonUserSearchResDTO = this.searchCommonUser(userId);
        if (null != commonUserSearchResDTO) {
            isRealName = commonUserSearchResDTO.getIsRealName();
        }
        return isRealName;
    }

    @Override
    public boolean checkRealNameAuthentication(String userName, String idCard) {
        RealNameAuthenticationReqDTO reqDTO = new RealNameAuthenticationReqDTO();
        reqDTO.setUserName(userName);
        reqDTO.setIdCard(idCard);
        DubboResult dubboResult = this.userServiceApi.checkRealNameAuthentication(reqDTO);
        if (dubboResult.isSuccess()) {
            return (Boolean)dubboResult.getData();
        }
        return false;
    }

    @Override
    public String getUserNameByJWT() {
        String userName = JWTContextUtil.getCurrentUserName();
        if (StringUtils.isBlank((String)userName)) {
            String userId = JWTContextUtil.getCurrentUserId();
            CommonUserSearchResDTO resDTO = this.searchCommonUser(Long.valueOf(userId));
            userName = resDTO.getUserName();
        }
        return userName;
    }

    @Override
    public Map<Long, UserInfoDTO> getUserInfoMap(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Maps.newHashMap();
        }
        DubboResult dubboUserList = this.userServiceSecondApi.searchUserInfoByUserId(userIds);
        AssertUtils.assertTrue((boolean)dubboUserList.isSuccess(), (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)dubboUserList.getMessage());
        List userInfoList = (List)((Object)dubboUserList.getData());
        return userInfoList.stream().collect(Collectors.toMap(UserInfoDTO::getUserId, Function.identity()));
    }

    @Override
    public UserInfoDTO getUserInfoById(Long userId) {
        if (null == userId) {
            return null;
        }
        Map<Long, UserInfoDTO> userInfoMap = this.getUserInfoMap(Lists.newArrayList((Object[])new Long[]{userId}));
        UserInfoDTO userInfoDTO = userInfoMap.get(userId);
        return userInfoDTO;
    }
}

